/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.pact;

import com.atlassian.oai.validator.report.ValidationReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class PactProviderValidationResults {
    private final List<ConsumerResult> results = new ArrayList<ConsumerResult>();

    public List<ConsumerResult> getConsumerResults() {
        return Collections.unmodifiableList(this.results);
    }

    public Optional<ConsumerResult> getConsumerResult(String name) {
        return this.results.stream().filter(r -> r.getConsumerName().equals(name)).findFirst();
    }

    public List<ConsumerResult> getFailedConsumerResults() {
        return this.results.stream().filter(ConsumerResult::hasErrors).collect(Collectors.toList());
    }

    public boolean hasErrors() {
        return this.results.stream().anyMatch(ConsumerResult::hasErrors);
    }

    public void addConsumerResult(ConsumerResult result) {
        this.results.add(result);
    }

    public void addConsumerResults(Collection<ConsumerResult> results) {
        this.results.addAll(results);
    }

    public String getValidationFailureReport() {
        StringBuilder msg = new StringBuilder();
        this.getFailedConsumerResults().forEach(r -> {
            msg.append("* ").append(r.getConsumerName()).append('\n');
            r.getFailedInteractions().forEach((i, v) -> {
                msg.append("\t- ").append((String)i).append("\t");
                v.getMessages().stream().filter(m -> m.getLevel() == ValidationReport.Level.ERROR).forEach(m -> msg.append("\n\t\t[").append(m.getLevel()).append("] ").append(m.getMessage().replace("\n", "\n\t\t")));
            });
        });
        return msg.toString();
    }

    public static class ConsumerResult {
        private final String consumerName;
        private final String consumerPact;
        private final Map<String, ValidationReport> interactionResults = new HashMap<String, ValidationReport>();

        public ConsumerResult(String consumerName, String consumerPact) {
            this.consumerName = consumerName;
            this.consumerPact = consumerPact;
        }

        public String getConsumerName() {
            return this.consumerName;
        }

        public String getConsumerPact() {
            return this.consumerPact;
        }

        public Map<String, ValidationReport> getInteractionResults() {
            return Collections.unmodifiableMap(this.interactionResults);
        }

        public Map<String, ValidationReport> getFailedInteractions() {
            return this.interactionResults.entrySet().stream().filter(e -> ((ValidationReport)e.getValue()).hasErrors()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public void addInteractionResult(String name, ValidationReport report) {
            this.interactionResults.merge(name, report, ValidationReport::merge);
        }

        boolean hasErrors() {
            return this.interactionResults.values().stream().anyMatch(ValidationReport::hasErrors);
        }
    }
}

