/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nekohtml.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FastHashMap<K, V>
implements Serializable {
    private static final Object FREE_KEY = new Object();
    private static final Object REMOVED_KEY = new Object();
    private Object[] m_data_;
    private final float m_fillFactor_;
    private int m_threshold_;
    private int m_size_;
    private int m_mask_;
    private int m_mask2_;

    public FastHashMap() {
        this(7, 0.5f);
    }

    public FastHashMap(int size, float fillFactor) {
        if (fillFactor <= 0.0f || fillFactor >= 1.0f) {
            throw new IllegalArgumentException("FillFactor must be in (0, 1)");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive!");
        }
        int capacity = FastHashMap.arraySize(size, fillFactor);
        this.m_mask_ = capacity - 1;
        this.m_mask2_ = capacity * 2 - 1;
        this.m_fillFactor_ = fillFactor;
        this.m_data_ = new Object[capacity * 2];
        Arrays.fill(this.m_data_, FREE_KEY);
        this.m_threshold_ = (int)((float)capacity * fillFactor);
    }

    public V get(K key) {
        int srcHashCode = key.hashCode();
        int ptr = (srcHashCode & this.m_mask_) << 1;
        Object k = this.m_data_[ptr];
        if (k == FREE_KEY) {
            return null;
        }
        if (k.hashCode() == srcHashCode && k.equals(key)) {
            return (V)this.m_data_[ptr + 1];
        }
        do {
            if ((k = this.m_data_[ptr = ptr + 2 & this.m_mask2_]) != FREE_KEY) continue;
            return null;
        } while (k.hashCode() != srcHashCode || !k.equals(key));
        return (V)this.m_data_[ptr + 1];
    }

    public V put(K key, V value) {
        int ptr = this.getStartIndex(key) << 1;
        Object k = this.m_data_[ptr];
        if (k == FREE_KEY) {
            this.m_data_[ptr] = key;
            this.m_data_[ptr + 1] = value;
            if (this.m_size_ >= this.m_threshold_) {
                this.rehash(this.m_data_.length * 2);
            } else {
                ++this.m_size_;
            }
            return null;
        }
        if (k.equals(key)) {
            Object ret = this.m_data_[ptr + 1];
            this.m_data_[ptr + 1] = value;
            return (V)ret;
        }
        int firstRemoved = -1;
        if (k == REMOVED_KEY) {
            firstRemoved = ptr;
        }
        while (true) {
            if ((k = this.m_data_[ptr = ptr + 2 & this.m_mask2_]) == FREE_KEY) {
                if (firstRemoved != -1) {
                    ptr = firstRemoved;
                }
                this.m_data_[ptr] = key;
                this.m_data_[ptr + 1] = value;
                if (this.m_size_ >= this.m_threshold_) {
                    this.rehash(this.m_data_.length * 2);
                } else {
                    ++this.m_size_;
                }
                return null;
            }
            if (k.equals(key)) {
                Object ret = this.m_data_[ptr + 1];
                this.m_data_[ptr + 1] = value;
                return (V)ret;
            }
            if (k != REMOVED_KEY || firstRemoved != -1) continue;
            firstRemoved = ptr;
        }
    }

    public V remove(K key) {
        int ptr = this.getStartIndex(key) << 1;
        Object k = this.m_data_[ptr];
        if (k == FREE_KEY) {
            return null;
        }
        if (k.equals(key)) {
            --this.m_size_;
            this.m_data_[ptr] = this.m_data_[ptr + 2 & this.m_mask2_] == FREE_KEY ? FREE_KEY : REMOVED_KEY;
            Object ret = this.m_data_[ptr + 1];
            this.m_data_[ptr + 1] = null;
            return (V)ret;
        }
        do {
            if ((k = this.m_data_[ptr = ptr + 2 & this.m_mask2_]) != FREE_KEY) continue;
            return null;
        } while (!k.equals(key));
        --this.m_size_;
        this.m_data_[ptr] = this.m_data_[ptr + 2 & this.m_mask2_] == FREE_KEY ? FREE_KEY : REMOVED_KEY;
        Object ret = this.m_data_[ptr + 1];
        this.m_data_[ptr + 1] = null;
        return (V)ret;
    }

    public int size() {
        return this.m_size_;
    }

    private void rehash(int newCapacity) {
        this.m_threshold_ = (int)((float)(newCapacity / 2) * this.m_fillFactor_);
        this.m_mask_ = newCapacity / 2 - 1;
        this.m_mask2_ = newCapacity - 1;
        int oldCapacity = this.m_data_.length;
        Object[] oldData = this.m_data_;
        this.m_data_ = new Object[newCapacity];
        Arrays.fill(this.m_data_, FREE_KEY);
        this.m_size_ = 0;
        for (int i = 0; i < oldCapacity; i += 2) {
            Object oldKey = oldData[i];
            if (oldKey == FREE_KEY || oldKey == REMOVED_KEY) continue;
            this.put(oldKey, oldData[i + 1]);
        }
    }

    public List<K> keys() {
        ArrayList<Object> result = new ArrayList<Object>(this.size());
        int length = this.m_data_.length;
        for (int i = 0; i < length; i += 2) {
            Object o = this.m_data_[i];
            if (o == FREE_KEY || o == REMOVED_KEY) continue;
            result.add(o);
        }
        return result;
    }

    public List<V> values() {
        ArrayList<Object> result = new ArrayList<Object>(this.size());
        int length = this.m_data_.length;
        for (int i = 0; i < length; i += 2) {
            Object o = this.m_data_[i];
            if (o == FREE_KEY || o == REMOVED_KEY) continue;
            result.add(this.m_data_[i + 1]);
        }
        return result;
    }

    public void clear() {
        this.m_size_ = 0;
        Arrays.fill(this.m_data_, FREE_KEY);
    }

    private int getStartIndex(Object key) {
        return key.hashCode() & this.m_mask_;
    }

    public static long nextPowerOfTwo(long x) {
        if (x == 0L) {
            return 1L;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return (x | x >> 32) + 1L;
    }

    public static int arraySize(int expected, float f) {
        long s = Math.max(2L, FastHashMap.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        Object[] srcData = Arrays.copyOf(this.m_data_, this.m_data_.length);
        this.clear();
        for (int i = 0; i < srcData.length; i += 2) {
            Object key = srcData[i];
            if (key == null) continue;
            Object value = srcData[i + 1];
            this.put(key, value);
        }
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        for (int i = 0; i < this.m_data_.length; ++i) {
            Object entry = this.m_data_[i];
            if (entry != FREE_KEY && entry != REMOVED_KEY) continue;
            this.m_data_[i] = null;
        }
        aOutputStream.defaultWriteObject();
    }
}

