/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.providers.jira;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueWatcherAddedEvent;
import com.atlassian.jira.event.issue.IssueWatcherDeletedEvent;
import com.atlassian.jira.event.issue.MentionIssueCommentEvent;
import com.atlassian.jira.event.issue.MentionIssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.plugins.share.event.ShareIssueEvent;
import com.atlassian.jira.plugins.share.event.ShareJqlEvent;
import com.atlassian.jira.plugins.share.event.ShareSearchRequestEvent;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.providers.jira.FieldHelper;
import com.atlassian.mywork.providers.jira.JiraAction;
import com.atlassian.mywork.service.HostService;
import com.atlassian.mywork.service.NotificationService;
import com.atlassian.mywork.service.ServiceSelector;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraEventListener
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(JiraEventListener.class);
    private static final String ACTION_JIRA_ISSUE_USER_MENTION = "mentions.user";
    private final ConcurrentHashMap<Long, EventHandler> eventTypeHandlers = new ConcurrentHashMap();
    private final EventPublisher eventPublisher;
    private final NotificationService notificationService;
    private final FieldHelper fieldHelper;
    private final IssueManager issueManager;
    private final RendererManager rendererManager;
    private final EventHandler unrecognisedEventHandler;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final CommentPermissionManager commentPermissionManager;
    private final ServiceSelector serviceSelector;
    private final ShareManager shareManager;
    private final HostService hostService;
    private final ObjectMapper objectMapper;
    private static final ApplicationUser ANONYMOUS_USER = new ApplicationUser(){

        public Long getId() {
            return 0L;
        }

        public long getDirectoryId() {
            return 0L;
        }

        public boolean isActive() {
            return false;
        }

        public String getEmailAddress() {
            return null;
        }

        public String getDisplayName() {
            return "Anonymous";
        }

        public User getDirectoryUser() {
            return null;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String getKey() {
            return this.getName();
        }

        public String getUsername() {
            return this.getName();
        }

        public String getName() {
            return "anonymous";
        }
    };

    public JiraEventListener(EventPublisher eventPublisher, NotificationService notificationService, FieldHelper fieldHelper, IssueManager issueManager, RendererManager rendererManager, UserManager userManager, PermissionManager permissionManager, CommentPermissionManager commentPermissionManager, ServiceSelector serviceSelector, ShareManager shareManager, HostService hostService) {
        EventHandler ignoredEventHandler = new EventHandler(){

            @Override
            public void handle(IssueEvent event) {
                log.debug("Got event of type: {} which will be ignored, because is present in ignored events list.", (Object)JiraEventListener.this.getTypeOfEvent(event));
            }
        };
        EventHandler commentedHandler = new EventHandler(){

            @Override
            public void handle(IssueEvent event) {
                JiraEventListener.this.commentedOnItem(event);
            }
        };
        this.eventTypeHandlers.put(EventType.ISSUE_CREATED_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_UPDATED_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_ASSIGNED_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_RESOLVED_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_CLOSED_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_COMMENTED_ID, commentedHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_REOPENED_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_DELETED_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_MOVED_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_WORKLOGGED_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_WORKSTARTED_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_WORKSTOPPED_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_GENERICEVENT_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_COMMENT_EDITED_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_WORKLOG_UPDATED_ID, ignoredEventHandler);
        this.eventTypeHandlers.put(EventType.ISSUE_WORKLOG_DELETED_ID, ignoredEventHandler);
        this.unrecognisedEventHandler = new EventHandler(){

            @Override
            public void handle(IssueEvent event) {
                log.debug("IssueEvent with unrecognised type ID: {}", (Object)event.getEventTypeId());
            }
        };
        this.objectMapper = new ObjectMapper();
        this.eventPublisher = eventPublisher;
        this.notificationService = notificationService;
        this.fieldHelper = fieldHelper;
        this.issueManager = issueManager;
        this.rendererManager = rendererManager;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.commentPermissionManager = commentPermissionManager;
        this.serviceSelector = serviceSelector;
        this.shareManager = shareManager;
        this.hostService = hostService;
    }

    public void onStart() {
        this.eventPublisher.register((Object)this);
    }

    public void onStop() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onIssueEvent(final IssueEvent event) {
        this.handleEventWithTargetServiceCheck(event, new Runnable(){

            @Override
            public void run() {
                EventHandler eventHandler = (EventHandler)JiraEventListener.this.eventTypeHandlers.get(event.getEventTypeId());
                (eventHandler == null ? JiraEventListener.this.unrecognisedEventHandler : eventHandler).handle(event);
            }
        });
    }

    @EventListener
    public void onMentionIssueCommentEvent(final MentionIssueCommentEvent event) {
        this.handleEventWithTargetServiceCheck(event, new Runnable(){

            @Override
            public void run() {
                JiraEventListener.this.onMentionIssueEvent((MentionIssueEvent)event, JiraEventListener.this.fieldHelper.issueCommentUrl(event.getIssue(), event.getComment()));
            }
        });
    }

    @EventListener
    public void onMentionIssueEvent(final MentionIssueEvent event) {
        this.handleEventWithTargetServiceCheck(event, new Runnable(){

            @Override
            public void run() {
                if (!(event instanceof MentionIssueCommentEvent)) {
                    JiraEventListener.this.onMentionIssueEvent(event, JiraEventListener.this.fieldHelper.issueUrl(event.getIssue()));
                }
            }
        });
    }

    public void handleEventWithTargetServiceCheck(Object event, Runnable eventHandler) {
        ServiceSelector.Target effectiveTarget = this.serviceSelector.getEffectiveTarget();
        if (effectiveTarget == ServiceSelector.Target.NONE || effectiveTarget == null) {
            this.logIgnoredEventBecauseOfNoneTarget(effectiveTarget, event);
            return;
        }
        eventHandler.run();
    }

    private void logIgnoredEventBecauseOfNoneTarget(ServiceSelector.Target effectiveTarget, Object event) {
        String effectiveTargetAsString = effectiveTarget != null ? effectiveTarget.toString() : "null;";
        log.debug("Event of type: {} will be ignored because target service is {}", (Object)this.getTypeOfEvent(event), (Object)effectiveTargetAsString);
    }

    private String getTypeOfEvent(Object event) {
        return event != null ? event.getClass().getName() : "null";
    }

    private void onMentionIssueEvent(MentionIssueEvent event, String url) {
        ApplicationUser fromUser = this.getSafeUser(event.getFromUser());
        String title = fromUser.getDisplayName() + " mentioned you in an issue.";
        String mentionText = this.renderComment(event.getIssue(), event.getMentionText());
        HashSet watchers = new HashSet(this.issueManager.getWatchers(event.getIssue()));
        for (ApplicationUser user : event.getToUsers()) {
            if (user.equals((Object)fromUser) || watchers.contains(user)) continue;
            String userName = user.getName();
            Notification notification = this.fieldHelper.createNotification(user, event.getIssue(), fromUser, JiraAction.MENTION).title(title).description(mentionText).action(ACTION_JIRA_ISSUE_USER_MENTION).url(url).createNotification();
            this.notificationService.createOrUpdate(userName, notification);
            log.debug("Created notification for user {}.", (Object)userName);
        }
    }

    @EventListener
    public void onShareIssueEvent(final ShareIssueEvent event) {
        this.handleEventWithTargetServiceCheck(event, new Runnable(){

            @Override
            public void run() {
                ApplicationUser fromUser = JiraEventListener.this.getSafeUser(event.getFromUser());
                String title = fromUser.getDisplayName() + " shared an issue with you.";
                for (String userName : event.getToUsernames()) {
                    ApplicationUser user = JiraEventListener.this.userManager.getUserByName(userName);
                    Notification notification = JiraEventListener.this.fieldHelper.createNotification(user, event.getIssue(), fromUser, JiraAction.SHARE).title(title).description(event.getComment()).createNotification();
                    JiraEventListener.this.notificationService.createOrUpdate(userName, notification);
                    log.debug("Created notification for user {}.", (Object)userName);
                }
            }
        });
    }

    @EventListener
    public void onShareFilterEvent(final ShareSearchRequestEvent event) {
        this.handleEventWithTargetServiceCheck(event, new Runnable(){

            @Override
            public void run() {
                ApplicationUser fromUser = JiraEventListener.this.getSafeUser(event.getFromUser());
                for (String userName : event.getToUsernames()) {
                    NotificationBuilder builder;
                    ApplicationUser toUser = JiraEventListener.this.userManager.getUser(userName);
                    if (JiraEventListener.this.shareManager.isSharedWith(toUser, (SharedEntity)event.getFilter())) {
                        builder = JiraEventListener.this.fieldHelper.createNotification(event.getFilter(), fromUser, JiraAction.SHARE);
                    } else {
                        String jql = event.getFilter().getQuery().getQueryString();
                        builder = JiraEventListener.this.fieldHelper.createNotification(jql, fromUser, JiraAction.SHARE);
                    }
                    Notification notification = builder.user(userName).description(event.getComment()).createNotification();
                    JiraEventListener.this.notificationService.createOrUpdate(userName, notification);
                    log.debug("Created notification for user {}.", (Object)userName);
                }
            }
        });
    }

    @EventListener
    public void onShareJqlEvent(final ShareJqlEvent event) {
        this.handleEventWithTargetServiceCheck(event, new Runnable(){

            @Override
            public void run() {
                ApplicationUser fromUser = JiraEventListener.this.getSafeUser(event.getFromUser());
                for (String userName : event.getToUsernames()) {
                    Notification notification = JiraEventListener.this.fieldHelper.createNotification(event.getJql(), fromUser, JiraAction.SHARE).user(userName).description(event.getComment()).createNotification();
                    JiraEventListener.this.notificationService.createOrUpdate(userName, notification);
                    log.debug("Created notification for user {}.", (Object)userName);
                }
            }
        });
    }

    @EventListener
    public void onIssueWatcherAddedEvent(final IssueWatcherAddedEvent event) {
        this.handleEventWithTargetServiceCheck(event, new Runnable(){

            @Override
            public void run() {
                JiraEventListener.this.watchEvent(event.getApplicationUser().getName(), event.getIssue().getId(), true);
            }
        });
    }

    @EventListener
    public void onIssueWatcherDeletedEvent(final IssueWatcherDeletedEvent event) {
        this.handleEventWithTargetServiceCheck(event, new Runnable(){

            @Override
            public void run() {
                JiraEventListener.this.watchEvent(event.getApplicationUser().getName(), event.getIssue().getId(), false);
            }
        });
    }

    @EventListener
    public void onClearCacheEvent(ClearCacheEvent event) {
        this.hostService.resetHosts();
    }

    private void watchEvent(String userName, Long issueId, boolean watch) {
        String globalId = this.fieldHelper.createGlobalId("issue", issueId);
        this.updateMetadata(userName, globalId, "watching", watch);
    }

    private void updateMetadata(String userName, String globalId, String field, boolean status) {
        ObjectNode metadata = this.objectMapper.createObjectNode();
        metadata.put(field, status);
        this.notificationService.updateMetadata(userName, globalId, this.objectMapper.createObjectNode(), metadata);
    }

    private void commentedOnItem(IssueEvent event) {
        Issue issue = event.getIssue();
        ApplicationUser fromUser = this.getSafeUser(event.getUser());
        String title = fromUser.getDisplayName() + " commented on an issue.";
        String comment = this.renderComment(issue, event.getComment().getBody());
        for (ApplicationUser user : this.issueManager.getWatchersFor(issue)) {
            if (!this.permissionManager.hasPermission(10, issue, user) || !this.commentPermissionManager.hasBrowsePermission(user, event.getComment())) continue;
            String userName = user.getName();
            Notification notification = this.fieldHelper.createNotification(user, issue, fromUser, JiraAction.COMMENT).title(title).description(comment).read(fromUser.getName().equals(user.getName())).url(this.fieldHelper.issueCommentUrl(issue, event.getComment())).createNotification();
            this.notificationService.createOrUpdate(userName, notification);
            log.debug("Created notification for user {}.", (Object)userName);
        }
    }

    private String renderComment(Issue issue, String comment) {
        return this.rendererManager.getRenderedContent("atlassian-wiki-renderer", comment, new IssueRenderContext(issue));
    }

    private ApplicationUser getSafeUser(ApplicationUser user) {
        return user != null ? user : ANONYMOUS_USER;
    }

    private static interface EventHandler {
        public void handle(IssueEvent var1);
    }
}

