/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.providers.jira;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.mywork.providers.jira.JiraRegistrationProvider;
import com.atlassian.mywork.service.ActionResult;
import com.atlassian.mywork.service.ActionService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraActionService
implements ActionService {
    private static final Logger log = LoggerFactory.getLogger(JiraActionService.class);
    private final UserManager userManager;
    private final IssueService issueService;
    private final CommentService commentService;
    private final WatcherService watcherService;
    private final ActionExecutor commentAction = new ActionExecutor(){

        @Override
        public ActionResult execute(ApplicationUser user, Issue issue, JsonNode action) {
            String body = action.path("comment").getTextValue();
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            JiraActionService.this.commentService.create(user, issue, body, true, (ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                log.info("Could not create comment: " + errorCollection.toString());
                return ActionResult.FAILED;
            }
            return ActionResult.SUCCESS;
        }
    };
    private final ActionExecutor unwatchAction = new ActionExecutor(){

        @Override
        public ActionResult execute(ApplicationUser user, Issue issue, JsonNode action) {
            JiraActionService.this.watcherService.removeWatcher(issue, user, user);
            return ActionResult.SUCCESS;
        }
    };
    private final ActionExecutor watchAction = new ActionExecutor(){

        @Override
        public ActionResult execute(ApplicationUser user, Issue issue, JsonNode action) {
            JiraActionService.this.watcherService.addWatcher(issue, user, user);
            return ActionResult.SUCCESS;
        }
    };
    private final Map<String, ActionExecutor> actionExecutors = ImmutableMap.builder().put((Object)"com.atlassian.mywork.providers.jira.issue.comment", (Object)this.commentAction).put((Object)"com.atlassian.mywork.providers.jira.issue.unwatch", (Object)this.unwatchAction).put((Object)"com.atlassian.mywork.providers.jira.issue.watch", (Object)this.watchAction).build();

    public JiraActionService(UserManager userManager, IssueService issueService, CommentService commentService, WatcherService watcherService) {
        this.userManager = userManager;
        this.issueService = issueService;
        this.commentService = commentService;
        this.watcherService = watcherService;
    }

    public String getApplication() {
        return new JiraRegistrationProvider().getApplication();
    }

    public ActionResult execute(String username, JsonNode action) {
        String qualifiedAction = action.path("qualifiedAction").getTextValue();
        ActionExecutor executor = this.actionExecutors.get(qualifiedAction);
        ApplicationUser user = this.userManager.getUserByName(username);
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, action.path("metadata").path("key").getTextValue());
        if (!issueResult.isValid()) {
            log.debug("Could not find issue: " + issueResult.getErrorCollection().toString());
            return ActionResult.FAILED;
        }
        return executor.execute(user, (Issue)issueResult.getIssue(), action);
    }

    private static interface ActionExecutor {
        public ActionResult execute(ApplicationUser var1, Issue var2, JsonNode var3);
    }
}

