// The main Notifications view which holds the list of notifications (notification-view.js)
MW.NotificationMainView = MW.NotificationMainAbstractView.extend({

    renderEmptyNotificationsTemplate: function(container){
        container.html(MyWork.Templates.noNotifications({
            heading: AJS.I18n.getText("com.atlassian.mywork.notification.first.header"),
            subheading: AJS.I18n.getText("com.atlassian.mywork.notification.first.subheader"),
            body: soydata.VERY_UNSAFE.ordainSanitizedHtml(AJS.I18n.getText("com.atlassian.mywork.notification.first.body"))

        }));
    },

    renderTemplate: function(container) {
        container.html(MyWork.Templates.mainNotification());
        container.find(".mw-button-notifications").toggleClass("on", true);
    },

    showCard: function(slideTime){
        MW.Router.navigateToMain();
        MW.Cookie.save(false);
        MW.CardAnimation.showCard(MW.$(this.el), MW.Slide.FROM_LEFT, slideTime, function(){
            MW.App.scrollToFocusedMain();
        });
    }
});

MW.NotificationView = MW.NotificationAbstractView.extend({
    initialize: function() {
        MW.NotificationView.__super__.initialize.apply(this, arguments);
        this.globalEvents.on("showNotificationCard", this.updateTime, this);
        this.globalEvents.on("reopenMiniview", this.updateTime, this);
        this.globalEvents.on("markAllRead", this.updateSeen, this);
    },

    updateTime: function() {
        this.$el.find('.mw-notification-time').text(this.model.getPrettyTime());
    },

    updateSeen: function() {
        MW.Notifications.setNotificationsAsRead(this.model.notifications, true);
        this.updateTitle();
        this.$el.removeClass("unread");
    },

    renderTemplate: function(container) {
        container.html(MyWork.Templates.notificationView({
            notification: this.model.toJSON(),
            prettyTime: this.model.getPrettyTime()
        }));
    },

    renderDrilldownTemplate: function(drilldownView){
        MW.$("#mw-container").append(drilldownView.render().el);
        this.globalEvents.trigger("showNotificationDrilldownCard");
    }
});

MW.NotificationEntryView = MW.NotificationEntryAbstractView.extend({
    createNotificationTitle: function(){
        return this.htmlTitle();
    },
    addTime: function($actions, time) {
        $actions.prepend(MW.$('<li />').text(time));
    },

    renderTemplate: function(container, templateParams){
        container.html(MyWork.Templates.drilldownEntry(templateParams));
    }
});

MW.HeaderView = MW.HeaderAbstractView.extend({
    renderTemplate: function(container, attributes, notificationGroup){
        container.html(MyWork.Templates.drilldownHeader(attributes));
        // TODO Temporary fix for summit
        if (notificationGroup.get('action') && notificationGroup.get('action').indexOf("task.") === 0) {
            container.find('.drilldown-star-container').hide();
        }
    }
});

MW.DrilldownView = MW.DrilldownAbstractView.extend({
    renderTemplate: function(container){
        container.html(MyWork.Templates.notificationDrilldown());
    },

    showCardAnimation: function(slideTime){
        MW.CardAnimation.showCard(MW.$(this.el), MW.Slide.FROM_RIGHT, slideTime);
    },

    showCardAnimationReverseSlide: function(slideTime){
        MW.CardAnimation.showCard(MW.$(this.el), MW.Slide.FROM_LEFT, slideTime);
    },

    showCollapsedGroup: function($collapsedGroup, callback) {
        $collapsedGroup.slideToggle(300, function() {
            $collapsedGroup.focus();
            if (callback) {
                callback();
            }
        });
    }
});

MW.ActionView = MW.ActionAbstractView.extend({
    showForm: function($formElement) {
        $formElement.slideDown(100, function() {
            MW.App.scrollToFocusedElement('.mw-drilldown-container', '.mw-notification-drilldown', $formElement.parents('.mw-drilldown-list'));
            $formElement.find('textarea').first().each(function(i, textarea) {
                if (textarea.setSelectionRange) {
                    textarea.focus();
                    textarea.setSelectionRange(0, 0);
                }
            });
        });
    },

    renderForm: function() {
        var $form = MW.ActionAbstractView.prototype.renderForm.apply(this, arguments);
        // Make any textareas auto-resizing (so they grow as typed into).
        MW.makeTextAreaExpandable($form, function(){
            MW.App.scrollToFocusedElement(".mw-drilldown-container", ".mw-notification-drilldown", MW.$(".inline-action-submit"));
        });
        return $form;
    },

    getFormContainerTemplate: function(){
        return MyWork.Templates.inlineActionForm();
    },

    getFormTextareaTemplate: function(){
        return MyWork.Templates.inlineActionTextarea();
    },

    getFormActionButtonsTemplate: function(submitText){
        return MyWork.Templates.inlineActionSubmit(submitText);
    }
});
