MW.Task = Backbone.Model.extend({
    setState: function(status) {
        if (this.config.getTaskActions(this.get("entity"), this.get("action")).length > 0) {
            MW.$.ajax({
                type: 'POST',
                url: MW.contextPath + '/rest/mywork/1/action/task',
                dataType: "json",
                contentType:'application/json',
                data: JSON.stringify({
                    application: this.get("application"),
                    qualifiedAction: this.get("category"),
                    id: this.get('id'),
                    status: status,
                    metadata: this.get('metadata')
                })
            });
        }
        this.save({status : status});
        MW.Notifications.setStatusByGlobalId(this.get('globalId'), status);
    },

    reorder: function(belowItemId) {
        var that = this;
        // persist order in backend
        MW.$.ajax({
            url: MW.contextPath + "/rest/mywork/latest/task/" + that.get("id") + "/position",
            type: "PUT",
            contentType: "application/json",
            data: JSON.stringify({"before": belowItemId})
        });
    },

    initialize: function() {
        this.parse(this.attributes);
    },

    parse: function(task) {

        if (!task.item) {
            task.item = {};
        }

        var taskItem = task.item,
            hasConfig = MW.Configurations.hasConfig(task),
            taskConfig = this.config = MW.Configurations.getFromNotification(task);

        task.title = task.title || taskItem.title;

        task.category = task.application + "." + task.entity;

        if (hasConfig) {
            if (taskItem) {
                if (taskItem.url && taskItem.url.indexOf('/') === 0) {
                    taskItem.url = taskConfig.get('url') + taskItem.url;
                }
                if (taskItem.iconUrl && taskItem.iconUrl.indexOf('/') === 0) {
                    taskItem.iconUrl = taskConfig.get('url') + taskItem.iconUrl;
                }
            }
        }

        taskItem.displayIconUrl = taskItem.iconUrl || this.config.appendUrl(task.category);

        if (this.hasDisplayIconClass(task.entity)) {
            taskItem.displayIconClass = "mw-icon-" + task.entity;
        }

        task.readonlyTitle = this.config.getProperty(task.category, 'readonlyTitle') == 'true';

        return task;
    },


    hasDisplayIconClass: function(entity){
        return _.include(["blog", "page", "comment", "inline-task"], entity);
    },

    setTitle: function(title) {
        if (this.get("title") != title) {
            this.save({title: title});
        }
    },

    setNotes: function(notes) {
        var that = this;
        if (this.get("notes") != notes) {
            MW.$.ajax({
                url: MW.contextPath + "/rest/mywork/latest/task/" + that.get("id") + "/notes",
                type: "PUT",
                contentType: "application/json",
                data: JSON.stringify(notes)
            });
            this.set({notes : notes});
        }
    },

    isCompleted: function() {
        return this.get("status") === "DONE";
    }
});
