AJS.EventQueue = AJS.EventQueue || [];
MW.MAX_RESULTS = 30;


MW.$(function($){
    // We bind global events across cards to this object.
    var globalEvents = _.extend({}, Backbone.Events);
    MW.contextPath = ConfluenceMobile.AppData.get("confluence-context-path");

    //only make request to get notification count for login user
    var currentUser = ConfluenceMobile.AppData.getObject("current-user");
    if (currentUser && !currentUser.anonymousUser) {
        MW.AnchorManager = new MW.AnchorUtil($, MW.contextPath, function(count) {
            $('.notification-count').text(count).toggleClass('new-notifications', count !== 0);
        });
        MW.AnchorManager.setupAnchors();
    }

    MW.CardAnimation = new MW.CardTransitions({globalEvents: globalEvents});

    MW.MobileApp = (function(){
        var notificationMainListView, taskMainListView;

        var updateNotifications = function(options) {
            MW.Configurations.fetchOnce().done(function() {
                MW.Notifications.fetcher(options);
            });
        };

        var createNotificationMainView = function(){
            var first = !notificationMainListView;
            if ($(".mw-list-container.mw-notification").length === 0) {
                $("#inner-container").append("<div class='mw-list-container mw-notification'></div>");
                notificationMainListView = new MW.NotificationMainView({
                    globalEvents: globalEvents,
                    el: $("#inner-container .mw-list-container.mw-notification")[0]
                });
                notificationMainListView.render();
            }
            if (first) {
                var loading = new ConfluenceMobile.Notification(notificationMainListView.notificationList);
                loading.showLoading();
                updateNotifications({silent: true, success: function() {
                    loading.hide();
                    notificationMainListView.addNotificationsToContainer();
                }});
            } else {
                notificationMainListView.addNotificationsToContainer();
            }
        };

        var createTaskMainView = function(){
            if ($(".mw-list-container.mw-task").length === 0) {
                $("#inner-container").append("<div class='mw-list-container mw-task'></div>");
                taskMainListView = new MW.TaskMainView({
                    globalEvents: globalEvents,
                    el: $("#inner-container .mw-list-container.mw-task")[0]
                });
                taskMainListView.render();
                loadTasks();
            }
        };

        var showMainView = function(view, other) {
            view.$el.addClass("showing").removeClass("hiding").removeClass("hidden").show();

            if (other) {
                other.$el.removeClass("showing").hide();
            }
        };

        var showNotificationMainView = function() {
            showMainView(notificationMainListView, taskMainListView);
        };

        var showTaskMainView = function() {
            showMainView(taskMainListView, notificationMainListView);
        };

        var hideAllTheThings = function() {
            MW.hideConfluenceMobileDashboard();

            $("body").removeClass("android-input-hack");
            if ($(".mw-list-container.mw-notification").length === 0) {
                createNotificationMainView();
                createTaskMainView();
                notificationMainListView.$el.removeClass("showing").hide();
                taskMainListView.$el.removeClass("showing").hide();
            }
        };

        var loadTasks = function() {
            taskMainListView && taskMainListView.showLoading();
            MW.Configurations.fetchOnce().done(function(){
                MW.Tasks.fetcher({add: false});
            });
        };

        var initialize = function(){
            MW.configurationVersion = $(".mw-flyout-container").attr('data-configuration-version');
            MW.setRequestTime($(".mw-flyout-container").attr('data-request-time'));
            MW.Configurations = new MW.ConfigurationCollection();
            MW.Notifications = new MW.NotificationCollection([], {
                globalEvents: globalEvents,
                config: MW.Configurations
            });
            MW.Tasks = new MW.TaskCollection([]);

            MW.Tasks.bind('destroy', function(task) {
                MW.Notifications.setStatusByGlobalId(task.get('globalId'), '');
            });

            // If we navigate to a non-mywork route, cleanup mywork stuff!
            ConfluenceMobile.routerEventAggregator.on("change", function(path) {
                if (path.indexOf("mywork") !== 0) {
                    notificationMainListView && notificationMainListView.cleanUp();
                    taskMainListView && taskMainListView.cleanUp();
                    MW.cleanupMWElements();
                    globalEvents.off(); // unbind all of our global events
                }
                var re = /^#content\/view\/(\d+)/i;
                var match = location.hash.match(re);
                if (match) {
                    var contentId = match[1];
                    MW.AnchorManager && MW.AnchorManager.updateAnchors(contentId);
                }
            });

            // When we click on 'Notifications' in fly-out, we want to zero-out the count and fetch for new notifications
            $('.fly-out .nav .content-link.mw-notifications').on('click', function(){
                $('.notification-count').text("0").toggleClass('new-notifications', false); // zero-out flyout count
                updateNotifications({updateOnly: true});
            });
            $('.fly-out .nav .content-link.mw-tasks').on('click', function(){
                loadTasks();
            });
            $('.fly-out .nav a').click(function() {
                if ($(this).attr('href').indexOf('#mywork') === 0) {
                    ConfluenceMobile.flyout.hide();
                }
            });
            MW.hackFunction(ConfluenceMobile.flyout, '_update', function(callback) {
                $('.mw-header .flyout-button').toggleClass('activated', this.visible);
                callback();
            });
        };

        var showTasks = function (completed) {
            hideAllTheThings();
            taskMainListView.completed = completed;

            if ($(".mw-notification").hasClass("showing")) {
                showTaskMainView();
            } else {
                taskMainListView.$el.show();
                MW.CardAnimation.showCard(taskMainListView.$el, MW.Slide.FROM_LEFT);
            }
            MW.Tasks.hasFetched.done(function(){
                completed ? taskMainListView.showCompleted() : taskMainListView.showUncompleted();
            });
        };

        initialize();

        return {
            notificationMain: function() {
                hideAllTheThings();
                if ($(".mw-task").hasClass("showing")) {
                    showNotificationMainView();
                } else {
                    notificationMainListView.$el.show();
                    MW.CardAnimation.showCard(notificationMainListView.$el, MW.Slide.FROM_LEFT);
                }
            },

            taskUncompleted: function() {
                showTasks(false);
            },

            taskCompleted: function () {
                showTasks(true);
            },

            notificationDrilldown: function(aggregateKey) {

                // If we came to this Notification by pressing the Back button from the *Task* for this Notification
                // (i.e. they clicked the green-tick button to the see the Task then clicked the browser back-button),
                // this drilldown should slide in from the LEFT and not the RIGHT.
                var reverseSlide = !!$('.mw-taskdetail-container').length;

                hideAllTheThings();
                var instant = !notificationMainListView.$el.hasClass("showing");

                // We want to try and show the drilldown directly
                if ($(".mw-notification-drilldown").length === 0) {
                    MW.Notifications.getByAggregateKeyDeferred(aggregateKey, function(notification){
                        // If no notification is found (bad aggregateKey) then go to main notifications list
                        if (_.isEmpty(notification)) {
                            MW.Router.navigateToMain({trigger: true});
                            return;
                        }

                        globalEvents.trigger("renderDrilldown", notification, instant, reverseSlide);
                    });
                }
            },

            taskDetailByGlobalId: function(globalId) {
                this.taskDetailLoad(_.bind(MW.Tasks.getByGlobalIdDeferred, MW.Tasks), globalId);
            },

            taskDetail: function(id) {
                this.taskDetailLoad(_.bind(MW.Tasks.getByIdDeferred, MW.Tasks), id);
            },

            taskDetailLoad: function(callback, id) {
                hideAllTheThings();
                var instant = !taskMainListView.$el.hasClass("showing");

                // We want to try and show the drilldown directly
                if ($(".mw-taskdetail").length === 0) {

                    callback(id, function(task) {
                        if (_.isEmpty(task)) {
                            MW.Router.navigateToTasks({trigger: true});
                            return;
                        }
                        globalEvents.trigger("showTaskDetail", task, instant);
                    });
                }
            }
        };
    })();

    MW.App = {};
    MW.App.parseView = function() {
        return "mobile";
    };
});
