/**
 * This module allows cards to register contexts, and keyboard shortcuts.
 * Only one context may be enabled at any given instance.
 */
MW.KeyboardShortcuts = function(globalEvents) {
    var kb = {},
        boundKeys = {},
        blocked = false;

    var initialize = function() {
        // Modifier keys trigger 'keydown' and not 'keypress'
        MW.$(document).bind("keydown", function(e){
            if (e.which == 27) { //esc
                parent.postMessage("escKey", "*");
            }
        });

        MW.$(document).bind('keypress', function (e) {
            var handled = kb.keyPressed(e.which);
            if (handled) { // As we run in an iframe, prevent keypresses from bubbling up to parent window.
                e.preventDefault();
                e.stopPropagation();
            }
        });

        globalEvents.on('blockKeyboardShortcut', function(){
            blocked = true;
        });

        globalEvents.on('unblockKeyboardShortcut', function(){
            blocked = false;
        });
    };

    kb.addShortcut = function(key, callback, context, callbackContext) {
        var contextBindings = boundKeys[context];
        contextBindings = contextBindings || {};
        contextBindings[key] = _.bind(callback, callbackContext);
        boundKeys[context] = contextBindings;
    };

    kb.setupContext = function(contextName, event, currentContext) {
        var eventListener = function() {
            kb.changeContext(contextName);
        };
        globalEvents.on(event, eventListener);

        return {
            cleanup: function() {
                globalEvents.off(event, eventListener);
                boundKeys[contextName] = {};
            },
            addShortcut: function(key, callback) {
                kb.addShortcut(key, callback, contextName, currentContext);
            }
        };
    };

    kb.changeContext = function(context) {
       kb.context = context;
    };

    kb.keyPressed = _.debounce(function(key) {
        if (!blocked) {
            var bindings = boundKeys[kb.context] || {};
            var callback = bindings[key];
            if (callback) {
                callback();
                return true; // Return true if the key was handled.
            }
        }
    },30);

    kb.clearShortcuts = function() {
        boundKeys = {};
    };

    initialize();
    return kb;
};

