MW.ConfigurationCollection = Backbone.Collection.extend({

    initialize: function(options) {
        this.model = MW.Configuration;
        this.url = MW.contextPath + "/rest/mywork/latest/configuration";

        this.blank = new MW.Configuration({i18n: {}, properties: {}});
    },

    fetchOnce: _.once(function() {
        var deferred = MW.$.Deferred();
        this.fetch({success: function() {
            deferred.resolve();
        }, data:{
            version: MW.configurationVersion
        }});
        return deferred;
    }),

    getFromNotificationRaw: function(notification) {
        return this.find(function(config) {
            return (notification.applicationLinkId || "") === config.get('appId') && notification.application == config.get('application');
        });
    },

    /**
     * Never returns null - will return a default configuration to handle missing registration.
     */
    getFromNotification: function(notification) {
        return this.getFromNotificationRaw(notification) || this.blank;
    },

    hasConfig: function(notification) {
        return typeof this.getFromNotificationRaw(notification) !== "undefined";
    }
});
