/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.service;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.confluence.cluster.shareddata.SharedData;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class ActiveClientsCache
implements Iterable<ApplicationId> {
    private static final Logger log = LoggerFactory.getLogger(ActiveClientsCache.class);
    private static final String KEY = "ActiveClients";
    private final SharedData sharedData;

    public ActiveClientsCache(SharedData sharedData) {
        this.sharedData = sharedData;
    }

    private Map<String, ImmutableSet<String>> getMap() {
        return this.sharedData.getMap();
    }

    public boolean isInitialized() {
        return this.getMap().containsKey(KEY);
    }

    private Set<String> getHostIds() {
        Set hostIds = (Set)this.getMap().get(KEY);
        return hostIds == null ? Sets.newHashSet() : Sets.newHashSet((Iterable)hostIds);
    }

    private void setHostIds(Iterable<String> hostIds) {
        this.getMap().put(KEY, (ImmutableSet<String>)ImmutableSet.copyOf(hostIds));
    }

    public void add(ApplicationId applicationId) {
        if (this.isInitialized()) {
            Set<String> hostIds = this.getHostIds();
            hostIds.add(applicationId.get());
            log.debug("Adding {} to ActiveClients, set is now {}", (Object)applicationId, hostIds);
            this.setHostIds(hostIds);
        } else {
            log.debug("ActiveClients cache is not initialized, re-initializing with {}", (Object)applicationId);
            this.setHostIds(Collections.singleton(applicationId.get()));
        }
    }

    public void remove(ApplicationId applicationId) {
        if (this.isInitialized()) {
            HashSet hostIds = Sets.newHashSet(this.getHostIds());
            hostIds.remove(applicationId.get());
            log.debug("Removing {} from ActiveClients, set is now {}", (Object)applicationId, (Object)hostIds);
            this.setHostIds(hostIds);
        } else {
            log.debug("ActiveClients cache is not initialized, skipping removal of {}", (Object)applicationId);
        }
    }

    @Override
    public Iterator<ApplicationId> iterator() {
        if (this.isInitialized()) {
            return Iterators.transform(this.getHostIds().iterator(), input -> new ApplicationId(input));
        }
        return Collections.emptyIterator();
    }
}

