/**
 * This view represents a single task item, in the task item list view.
 */
MW.TaskAbstractView = Backbone.View.extend({
    tagName: "li",
    className: "task",

    events:  {
        "click .item-content": "showDetail",
        "click .mw-task-text": "showDetail",
        "click .mw-drilldown-arrow": "showDetail",
        "click .mw-task-checkbox": "toggleStatus"
    },

    initialize: function(options) {
        this.globalEvents = options.globalEvents;
        this.model.bind("change", this.render, this);
        options.globalEvents.bind("reordered", this.reordered, this);
    },

    showDetail: function() {
        this.globalEvents.trigger("showTaskDetail", this.model);
    },

    toggleStatus: function() {
        if (!this.model.isCompleted()) {
            this.model.setState("DONE");
        } else {
            this.model.setState("TODO");
        }
    },

    /**
     * This function is used to reorder items in the DOM, and also persist the reordering.
     * @param currItemCid The cid of the item being moved
     * @param belowItemCid The cid of the item above its new position
     */
    reordered: function(currItemCid, belowItemCid) {
        if (this.model.cid === currItemCid) {
            var currItem = this.model;
            var belowItem = MW.Tasks.getByCid(belowItemCid);

            MW.Tasks.reorder(currItem, belowItem);
        }
    },

    getDisplayText: function() {
        // This is stored in two different ways due to legacy tasks.
        var text = this.model.get("title");
        if (!text) {
            text = ""; // If there really isn't any text due to corrupt data, just use an empty string.
        }
        return text;
    },

    render: function() {
        var $el = this.$el,
            text = this.getDisplayText(),
            tagRegex = /(^|\s)#(\w+)/g,
            matches = text.match(tagRegex);

        text = this.parseTagText(text, tagRegex);

        this.renderTemplate($el, text);

        this.renderTagLozenge(matches);

        if (this.model.isCompleted()) {
            $el.addClass("completed");
        } else {
            $el.removeClass("completed");
        }

        return this;
    }
});
