MW.$(function($){
    MW.Router = ConfluenceMobile.router;
    // this helper method should be moved to confluence
    ConfluenceMobile.router.addRoute = function(route, name, callback) {
        ConfluenceMobile.router.route(route, name, _.bind(callback, MW.MobileApp));

        // TODO Remove this when Confluence fix their default handling
        if (ConfluenceMobile.DesktopSwitch && ConfluenceMobile.DesktopSwitch._routeToUrlMappers) {
            ConfluenceMobile.DesktopSwitch._routeToUrlMappers[name] = function() {
                return 'dashboard.action?show-miniview';
            };
        }

        if (Backbone.history.getFragment().match(route.replace(/(:.*)/, '(.*)') + "$")) {
            // browser is targeting new route, after the router was started but before the new route was added
            // so let's load the URL again to invoke the new route
            Backbone.history.loadUrl();
        }
    };


    _.extend(MW.Router, {
        navigateToMain: function(options) {
            this.navigate("mywork/notification", options);
        },
        navigateToNotification: function(id, options) {
            this.navigate("mywork/notification/" + id, options);
        },
        navigateToTasks: function(options) {
            this.navigate("mywork/task", options);
        },
        navigateToCompletedTasks: function(options) {
            this.navigate("mywork/task-completed", options);
        },
        navigateToTask: function(id, options) {
            this.navigate("mywork/task/" + id, options);
        },
        taskByGlobalId: function(globalId) {
            MW.MobileApp.taskDetailByGlobalId(globalId);
        }
    });

    ConfluenceMobile.router.addRoute('mywork/task', 'tasks', MW.MobileApp.taskUncompleted);
    ConfluenceMobile.router.addRoute('mywork/task-completed', 'tasks-completed', MW.MobileApp.taskCompleted);
    ConfluenceMobile.router.addRoute('mywork/task/:task', 'task', MW.MobileApp.taskDetail);
    ConfluenceMobile.router.addRoute('mywork/notification', 'notifications', MW.MobileApp.notificationMain);
    ConfluenceMobile.router.addRoute('mywork/notification/:aggregateKey', 'notification', MW.MobileApp.notificationDrilldown);

});
