MW.TaskCollection = Backbone.Collection.extend({

    all: function() {
        return this.filter(function(item) {
            return true;
        });
    },

    initialize: function() {
        this.model = MW.Task;
        this.url = MW.contextPath + "/rest/mywork/latest/task";
        this.hasFetched = MW.Deferred();
    },

    fetchOnce: _.once(function(options) {
        this.fetcher(options);
    }),

    fetcher: function(options) {
        this.fetch(this.hasFetched.resolveOnSuccess(_.extend({
            add: true,
            data: {
                type: "inline_task"
            }
        }, options)));
    },

    reorder: function(currItem, belowItem) {
        // Handle edge case where item is moved to top of list (ie. below 'nothing')
        var newIndex, belowItemId;
        if (belowItem) {
            newIndex = this.indexOf(belowItem);
            belowItemId = belowItem.get("id");
        } else {
            newIndex = this.length;
        }

        // Make sure collection has correct order for newly reordered items.
        this.remove(currItem);
        this.add(currItem, {at: newIndex});

        // Persist the reordering to the backend
        currItem.reorder(belowItemId);
    },

    getByIdDeferred: function(id, callback) {
        var that = this;
        this.hasFetched.done(function() {
            callback(that.get(id));
        });
    },

    getByGlobalIdCheckHost: function(id, callback) {
        var that = this;
        this.getByGlobalIdDeferred(id, function(task) {
            if (task) { // Does the task exist locally?
                callback(task);
            } else { // Fetch tasks from host and try again
                that.fetcher({
                    add: false,
                    success: function() {
                        that.getByGlobalIdDeferred(id, callback);
                    }
                });
            }
        });
    },

    getByGlobalIdDeferred: function(id, callback) {
        var that = this;
        this.hasFetched.done(function() {
            callback(that.getByGlobalId(id));
        });
    },

    getByGlobalId: function(globalId) {
        return this.find(function(item) {
            return (item.get("globalId") === globalId);
        });
    },

    todo: function() {
        return this.filter(function(item) {
            return !item.isCompleted();
        });
    },

    done: function() {
        return this.doneBetween();
    },

    doneOlderThan: function(date) {
        return this.doneBetween(date);
    },

    doneNewerThan: function(date) {
        return this.doneBetween(null, date);
    },

    /*
     Returns list of done tasks between two specified dates
     If neither dates are supplied, all items are returned
     If only dateOne: returns items with updated timestamp older than dateOne
     If only dateTwo: returns items with updated timestamp newer than dateTwo
     <------[dateOne]-------[dateTwo]------>
     */
    doneBetween: function(dateOne, dateTwo) {
        return this.filter(function(item) {
            var lastUpdated = new Date(item.get("updated"));
            var isWithinDateRange;

            if (!dateOne && !dateTwo) {
                isWithinDateRange = true;
            } else if (!dateTwo) {
                isWithinDateRange = lastUpdated < dateOne;
            } else if (!dateOne) {
                isWithinDateRange = lastUpdated >= dateTwo;
            } else {
                isWithinDateRange = (lastUpdated >= dateOne && lastUpdated < dateTwo);
            }

            if (isWithinDateRange) {
                return item.isCompleted();
            }
        });
    },

    parse: function(response) {
        var that = this;

        _.each(response, function(item) {
            item.displayName = item.item.title || "";
        });

        setTimeout(function() {
            // Reset isn't called for 'add' fetches
            that.trigger('fetch');
        });
        return response;
    }
});
