MW.TaskMainView = MW.TaskMainAbstractView.extend({

    makeTasksSortable: function() {
        var that = this;
        MW.$(".mw-tasks ul").sortable({
            disabled: false,
            handle: ".entire-task",
            axis: "y",
            tolerance: "pointer",
            opacity: 0.85,
            placeholder: "sortable-placeholder",
            update: function(event, ui) {
                var currCid = ui.item.attr("task-cid");
                var belowCid = ui.item.next().attr("task-cid");
                that.globalEvents.trigger("reordered", currCid, belowCid);
            }
        });
    },

    renderShowTaskDetailView: function(taskDetailView){
        MW.$("#mw-container").append(taskDetailView.render().el);
    },

    renderEmptyTaskTemplate: function(container){
        container.html(MyWork.Templates.noTasks({
            noTaskItem: AJS.I18n.getText('com.atlassian.mywork.tasks.first'),
            noTaskDescription: AJS.I18n.getText("com.atlassian.mywork.task.description"),
            noTask1: AJS.I18n.getText("com.atlassian.mywork.task.1"),
            noTask2: AJS.I18n.getText("com.atlassian.mywork.task.2"),
            noTask3: AJS.I18n.getText("com.atlassian.mywork.task.3")
        }));
    },

    renderEmptyCompletedTemplate: function(container) {
        //no op - should not be able to view 'Completed' in miniview if there are no completed tasks
    },

    renderTemplate: function(container){
        container.append(MyWork.Templates.mainTasks({
            addTaskPlaceholder: AJS.I18n.getText("com.atlassian.mywork.add.task.placeholder"),
            addTaskButtonText: AJS.I18n.getText("com.atlassian.mywork.addtask")
        }));
        container.find(".mw-button-tasks").toggleClass("on", true);
    },

    showUncompleted: function() {
        this.addTodo();
        this.viewCompleted.text(AJS.I18n.getText('com.atlassian.mywork.task.view.completed'));
        MW.$(".mw-tasks").toggleClass("completed", false);
        this.completed = false;
    },

    showCompleted: function() {
        this.addDone();
        MW.$(".mw-tasks ul").sortable("disable");
        MW.$(".mw-tasks .handle").hide();
        this.viewCompleted.text(AJS.I18n.getText('com.atlassian.mywork.task.hide.completed'));
        MW.$(".mw-tasks").toggleClass("completed", true);
        this.completed = true;
    },

    showAddTaskOverlay: function() {
        //noop
    },

    disableAddTask: function() {
        var isDisabled = MW.$.trim(this.input.val()).length === 0;
        this.addTask.prop('disabled', isDisabled);
        this.addTask.toggleClass('disabled', isDisabled);
    },

    showCard:function(slideTime) {
        MW.Router.navigateToTasks();
        MW.Cookie.save(false);
        this.show();
        MW.CardAnimation.showCard(MW.$(this.el), MW.Slide.FROM_LEFT, slideTime);
    }
});


MW.TaskView = MW.TaskAbstractView.extend({

    renderTemplate: function(container, text){
        container.html(MyWork.Templates.personalTask({task: this.model.toJSON(), text: text}));
    },

    parseTagText: function(text, tagRegex){
        var parsedText = text;

        // Just return text as-is if not enabled
        if (AJS.DarkFeatures.isEnabled("nat.tags")) {
            // Look for hashtags in the text. Hashtags are category labels, remove them from the text
            // to be rendered.
            parsedText = text.replace(tagRegex, " ");
        }
        return parsedText;
    },

    renderTagLozenge: function(matches) {
        // noop if not enabled
        if (AJS.DarkFeatures.isEnabled("nat.tags")) {
            // Add category lozenges for each hashtag.
            // We are assuming the category names are in the format #example-category. Note that only the first
            // segment after the hash is used, so for #foo#bar, just use foo as the category.
            _.each(matches, function(category) {
                this.$el.find(".item-content").append(MyWork.Templates.categoryLabel({text: category.split("#")[1]}));
            });
        }
    }
});


MW.TaskDetailView = MW.TaskDetailAbstractView.extend({
    showCardAnimation: function(slideTime){
        MW.CardAnimation.showCard(MW.$(this.el), MW.Slide.FROM_RIGHT, slideTime);
    },

    showDeleteConfirmation: function(){
        var confirmText = AJS.I18n.getText('com.atlassian.mywork.task.delete.confirm');
        if (this.isInlineTask()) {
            confirmText = AJS.I18n.getText('com.atlassian.mywork.task.delete.confirm.inlinetask');
        }
        var result = confirm(confirmText);
        if (result) {
            this.removeTask();
        }
    },

    renderTemplate: function(container){
        var taskDetailHtml = MyWork.Templates.personalTaskDetail({
            backToTasksText: AJS.I18n.getText("com.atlassian.mywork.back.to.tasks"),
            task: this.model.attributes
        });

        container.html(taskDetailHtml);
        if(MW.$.browser.msie) {
            container.find(".mw-taskdetail-title").width("450px");
        }
    }
});