MW.$(function () {
    MW.Router = Backbone.Router.extend({
        initialize: function(options) {
            this.globalEvents = options.globalEvents;
        },

        routes: {
            "notification": "notifications",
            "task": "tasks",
            "notification/:id": "notification",
            "task/:id": "task",
            '*path':  'initial'
        },

        navigateToMain: function(options) {
            options = this.setDefaultOptions(options);
            this.navigate("notification", options);
        },

        navigateToNotification: function(id, options) {
            options = this.setDefaultOptions(options);
            this.navigate("notification/" + id, options);
        },

        navigateToTasks: function(options) {
            options = this.setDefaultOptions(options);
            this.navigate("task", options);
        },

        navigateToTask: function(id, options) {
            options = this.setDefaultOptions(options);
            this.navigate("task/" + id, options);
        },

        setDefaultOptions: function(options) {
            // In backbone history when we navigate, the line "location.hash = fragment" causes extra
            // entries to be added to the browser back.
            // So when in miniview, use "replace" to prevent adding to history
            // When not in miniview (ie. fullview) we want to add to the history
            options = options || {};
            _.extend(options, {replace: MW.$(".miniview-page").hasClass("iframe")});
            return options;
        },

        initial: function() {
            MW.App.gotoInitial();
        },

        notifications: function() {
            MW.App.gotoMain();
        },

        tasks: function() {
            MW.App.gotoTasks();
        },

        notification: function(id) {
            var that = this;
            MW.Notifications.getByAggregateKeyDeferred(id, function(notification){
                if (_.isEmpty(notification)) {
                    return that.notifications();
                }
                MW.Notifications.setFocused(notification);
                that.globalEvents.trigger("renderDrilldown", notification);
            });
        },

        taskByGlobalId: function(globalId) {
            MW.Tasks.getByGlobalIdDeferred(globalId, _.bind(this.task, this));
        },

        task: function(id) {
            MW.Tasks.getByIdDeferred(id, _.bind(function(task) {
                if (!task) {
                    return this.tasks();
                }
                MW.App.completed = !task.isCompleted();
                this.globalEvents.trigger("showTaskDetail", task);
            }, this));
        }
    });
});
