/**
 * Renders action message.
 */
MW.ActionMessageView = Backbone.View.extend({

    showErrorMessage: function(message) {
        // TODO Style the error message as we have just removed use of AJS.messages.error
        if (!message) {
            message = AJS.I18n.getText('com.atlassian.mywork.action.oh.no');
        }
        this.$el.text(message);
    },

    showLoginErrorMessage: function(messageHtml) {
        this.$el.html(messageHtml);
        this.$('a').click(function(e) {
            e.preventDefault();
            if (MW.App.parseView() === 'mobile') {
                ConfluenceMobile.loadLoginScreen(true);
            } else {
                location.reload(); // Redirects to login screen
            }
        });
    },

    showOAuthErrorMessage: function(messageHtml, authUrl) {
        var url = authUrl,
                callback = MW.createCallback(MW.getBaseUrl(), this.options.aggregateKey);
        if (callback) {
            url += MW.appendCallback(url, callback);
        }

        this.$el.html(messageHtml);
        this.$('a').attr('href', url);
    },

    clearMessage: function() {
        this.$el.empty();
    }
});