var MW = MW || { $ : AJS.$ || Zepto };
var can = {};

MW.$(function() {
    // from http://blog.pamelafox.org/2011/11/porting-from-jquery-to-zepto.html
    // TODO: we might be able to remove this for mobile - only using it to scrollTop(0) when creating new task
    ["Left", "Top"].forEach(function(name, i) {
        var method = "scroll" + name;

        function isWindow( obj ) {
            return obj && typeof obj === "object" && "setInterval" in obj;
        }

        function getWindow( elem ) {
            return isWindow( elem ) ? elem : elem.nodeType === 9 ? elem.defaultView || elem.parentWindow : false;
        }

        MW.$.fn[ method ] = function( val ) {
            var elem, win;

            if ( val === undefined ) {

                elem = this[ 0 ];

                if ( !elem ) {
                    return null;
                }

                win = getWindow( elem );

                // Return the scroll offset
                return win ? ("pageXOffset" in win) ? win[ i ? "pageYOffset" : "pageXOffset" ] :
                    win.document.documentElement[ method ] ||
                        win.document.body[ method ] :
                    elem[ method ];
            }

            // Set the scroll offset
            this.each(function() {
                win = getWindow( this );

                if ( win ) {
                    var xCoord = !i ? val : MW.$( win ).scrollLeft();
                    var yCoord = i ? val : MW.$( win ).scrollTop();
                    win.scrollTo(xCoord, yCoord);
                } else {
                    this[ method ] = val;
                }
            });
        };
    });



    // From can.js (http://canjs.us/)
    // With some minor modifications - in particular 'Deferred' is part of Zepto ($) instead of 'can'
    var Deferred = function( func ) {
        if ( ! ( this instanceof Deferred ))
            return new Deferred();

        this._doneFuncs = [];
        this._failFuncs = [];
        this._resultArgs = null;
        this._status = "";

        // Check for option `function` -- call it with this as context and as first
        // parameter, as specified in jQuery API.
        func && func.call(this, this);
    };
    MW.$.Deferred = Deferred;
    MW.$.when = function() {
        var args = can.makeArray( arguments );
        if (args.length < 2) {
            var obj = args[0];
            if (obj && ( MW.$.isFunction( obj.isResolved ) && MW.$.isFunction( obj.isRejected ))) {
                return obj;
            } else {
                return Deferred().resolve(obj);
            }
        } else {

            var df = Deferred(),
                done = 0,
                // Resolve params -- params of each resolve, we need to track them down
                // to be able to pass them in the correct order if the master
                // needs to be resolved.
                rp = [];

            can.each(args, function(arg, j){
                arg.done(function() {
                    rp[j] = (arguments.length < 2) ? arguments[0] : arguments;
                    if (++done == args.length) {
                        df.resolve.apply(df, rp);
                    }
                }).fail(function() {
                        df.reject(arguments);
                    });
            });

            return df;

        }
    };

    var resolveFunc = function(type, _status){
        return function(context){
            var args = this._resultArgs = (arguments.length > 1) ? arguments[1] : [];
            return this.exec(context, this[type], args, _status);
        };
    },
        doneFunc = function(type, _status){
            return function(){
                var self = this;
                // In Safari, the properties of the `arguments` object are not enumerable,
                // so we have to convert arguments to an `Array` that allows `can.each` to loop over them.
                can.each(Array.prototype.slice.call(arguments), function( v, i, args ) {
                    if ( ! v )
                        return;
                    if ( v.constructor === Array ) {
                        args.callee.apply(self, v);
                    } else {
                        // Immediately call the `function` if the deferred has been resolved.
                        if (self._status === _status)
                            v.apply(self, self._resultArgs || []);

                        self[type].push(v);
                    }
                });
                return this;
            };
        };

    MW.$.extend( Deferred.prototype, {
        pipe : function(done, fail){
            var d = AJS.$.Deferred();
            this.done(function(){
                d.resolve( done.apply(this, arguments) );
            });

            this.fail(function(){
                if(fail){
                    d.reject( fail.apply(this, arguments) );
                } else {
                    d.reject.apply(d, arguments);
                }
            });
            return d;
        },
        resolveWith : resolveFunc("_doneFuncs","rs"),
        rejectWith : resolveFunc("_failFuncs","rj"),
        done : doneFunc("_doneFuncs","rs"),
        fail : doneFunc("_failFuncs","rj"),
        always : function() {
            var args = can.makeArray(arguments);
            if (args.length && args[0])
                this.done(args[0]).fail(args[0]);

            return this;
        },

        then : function() {
            var args = can.makeArray( arguments );
            // Fail `function`(s)
            if (args.length > 1 && args[1])
                this.fail(args[1]);

            // Done `function`(s)
            if (args.length && args[0])
                this.done(args[0]);

            return this;
        },

        isResolved : function() {
            return this._status === "rs";
        },

        isRejected : function() {
            return this._status === "rj";
        },

        reject : function() {
            return this.rejectWith(this, arguments);
        },

        resolve : function() {
            return this.resolveWith(this, arguments);
        },

        exec : function(context, dst, args, st) {
            if (this._status !== "")
                return this;

            this._status = st;

            can.each(dst, function(d){
                d.apply(context, args);
            });

            return this;
        }
    });

    /**
     * Taken from can.js. Used in the can js deferred function above, and
     * is different to the default Zepto each loop.
     */
    can.each = function(elements, callback) {
        var i = 0, key;
        if ( elements ) {
            if (typeof  elements.length == 'number' && elements.pop) {
                elements.attr && elements.attr('length');
                for(var len = elements.length; i < len; i++) {
                    if(callback(elements[i], i, elements) === false) return elements;
                }
            } else {
                for(key in elements) {
                    if(callback(elements[key], key) === false) return elements;
                }
            }
        }
        return elements;
    };

    can.makeArray = function( arr ) {
        var ret = [];
        can.each(arr, function( a, i ) {
            ret[i] = a;
        });
        return ret;
    };


    // Only Zepto 1.0+ has $.trim() . Copied the below iOS 3.2 fix from Zepto itself
    if (String.prototype.trim === undefined) // fix for iOS 3.2
        String.prototype.trim = function(){
            return this.replace(/^\s+/, '').replace(/\s+$/, '');
        };

    MW.$.trim = function(text){
        return text.trim();
    };
});


/**
 * Most of the animation/slidy stuff for the mobile cards/overlays
 * Seems like we need to setTimeout 100ms for animations to work
 */
MW.Slide = {
    FROM_RIGHT : "from-right",
    FROM_LEFT : "from-left"
};

MW.CardTransitions = (function(options){
    var globalEvents;

    var initialize = function(options) {
        globalEvents = options.globalEvents;
    };

    var showCard = function(cardToShow, slideType, callback){

        var cardToHide = $(".showing");
        if (cardToHide[0] === cardToShow[0]) {
            // We're trying to go from a card to itself...
            callback && callback();
            return;
        }

        var showCardClass, hideCardClass;
        if (slideType === MW.Slide.FROM_RIGHT) {
            showCardClass = "off-right";
            hideCardClass = "off-left";
        } else if (slideType === MW.Slide.FROM_LEFT) {
            showCardClass = "off-left";
            hideCardClass = "off-right";
        } else {
            showCardClass = hideCardClass = "";
        }

        if(cardToHide.length > 0) {
            cardToShow.removeClass('transition-finished');
            cardToShow.addClass(showCardClass);
        }
        cardToHide.removeClass("showing");
        cardToShow.removeClass("hidden");
        setTimeout(function(){
            // Transition classes for webdriver tests
            cardToShow.addClass("showing").removeClass('hiding');
            cardToShow.one('webkitTransitionEnd', function(){
                cardToShow.addClass('transition-finished');
            });

            // Hide the currently visible card
            cardToHide.addClass("hiding").removeClass('transition-finished');
            cardToHide.one('webkitTransitionEnd', function(){

                cardToHide.addClass("hidden");
                // If going from nested to nested (atm drilldown -> taskdetail)
                // assume the main cards need to be hidden, and "swap" which one is off-left and which one is just hidden
                if (cardToHide.hasClass("nested-card") && cardToShow.hasClass("nested-card")) {
                    MW.$(".mw-list-container").removeClass("showing").toggleClass("off-left").hide();
                }

                if (cardToHide.hasClass("nested-card")) {
                    globalEvents.trigger("cleanupNestedCard");
                }

                if (callback) {
                    callback();
                }
            });

            // Actual transition
            cardToShow.removeClass(showCardClass);
            cardToHide.addClass(hideCardClass);
            if(cardToHide.length === 0) {
                if (callback) {
                    callback();
                }
            }
        },100);
    };

    initialize(options);

    return {
        showCard: showCard,
        showCardInstant: function(cardToShow, slideType, slideTime) {
            return showCard(cardToShow, slideType, function() {
                if (slideTime === 0) {
                    cardToShow.addClass('transition-finished');
                }
            });
        }
    };
});

// Show/Hide the respective cards - all the slide logic above does not guarantee that the cards are visible
MW.showTaskMainCard = function() {
    MW.$("#inner-container .mw-list-container.mw-task").show();
    MW.$("#inner-container .mw-list-container.mw-notification").hide();
};

MW.showNotificationMainCard = function() {
    MW.$("#inner-container .mw-list-container.mw-notification").show();
    MW.$("#inner-container .mw-list-container.mw-task").hide();
};

// Slide the top overlay (eg. add/delete task) from the top
MW.showTopOverlay = function(name){
    setTimeout(function(){
        var $topOverlay = MW.$(".mw-mobile-overlay." + name);
        $topOverlay.removeClass("completely-hidden");
        $topOverlay.one('webkitTransitionEnd', function(){
            $topOverlay.addClass('completely-visible');
        });
        // Now kick off the transition
        $topOverlay.removeClass("off-top");

        // Make sure overlay is visible
        MW.$('body').scrollTop(0);

        // Add overlay to make overlay modal
        MW.$('#inner-container').append('<div id="mw-modal-overlay"></div>');
    }, 100);
};

// Remove top overlays (optionally specify a specific one by classname)
MW.removeTopOverlay = function(name){
    var className = ".mw-mobile-overlay";
    if (name) {
        className = className + "." + name;
    }
    var $overlay = MW.$(className);
    $overlay.find('textarea').blur();
    // Without the timeout the page still goes white
    setTimeout(function() {
        $overlay.remove();
    }, 0);
    MW.$("#mw-modal-overlay").remove();
};

// Slide the top overlay off the top
MW.hideTopOverlay = function(name, isRemove){
    setTimeout(function(){
        var $topOverlay = MW.$(".mw-mobile-overlay." + name);
        $topOverlay.removeClass("completely-visible");
        $topOverlay.one('webkitTransitionEnd', function(){
            $topOverlay.addClass('completely-hidden');
        });
        // Now kick off the transition
        $topOverlay.addClass("off-top");
        MW.$("#mw-modal-overlay").remove();
        if (isRemove) {
            $topOverlay.bind("webkitTransitionEnd", function(){
                $topOverlay.unbind("webkitTransitionEnd");
                MW.removeTopOverlay();
            });
        }
    }, 100);
};

// Slide the top overlay off the top, and then remove when transition ends
// Note: if you just want to remove the top overlay without first sliding, call MW.removeTopOverlay() instead
MW.hideThenRemoveTopOverlay = function(name){
    MW.hideTopOverlay(name, true);
};

// Hide the Confluence container as we want our own containers to be visible
MW.hideConfluenceMobileDashboard = function(){
    MW.$("#inner-container .container").hide();

    // Add a class to indicate that we are now dealing with "my work" containers
    MW.$("#inner-container").addClass("mw-mobile-container");
};

// Cleanup all of the containers and classes we've added
MW.cleanupMWElements = function(){
    // TODO - this line can be removed once we're on the Confluence version of the CONFDEV-9960 fix.
    // Show confluence stuff
    MW.$("#inner-container .container").show();

    // Remove our own containers
    MW.$("#inner-container .mw-list-container").remove();
    MW.$("#inner-container .nested-card").remove();
    MW.$("#inner-container .mw-mobile-overlay").remove();
    MW.$("#inner-container").removeClass("mw-mobile-container");
};


/**
 * Overrides a function on an object, and passing a callback to the new version to be invoked at will.
 */
MW.hackFunction = function(that, f, override) {
    var old = that[f];
    that[f] = function() {
        var args = arguments;
        var context = this;
        override.call(context, function() {
            old.apply(context, args);
        });
    };
};

// Mobile has no concept of shortcuts, so provide dummy object
MW.KeyboardShortcuts = {
    changeContext: function(){},
    setupContext: function(){
        return {
            cleanup: function(){},
            addShortcut: function(){}
        };
    }
};