var MW = MW || { $ : AJS.$ || Zepto };
MW.MV = {};

AJS.toInit(function () {
    // Only show the anchor if the user is logged in.
    if (AJS.Meta && !AJS.Meta.get("remote-user")) {
        return;
    }

    MW.MV.AnchorManager = function () {
        var xpxBaseUrl = contextPath,
            notificationsIframeUrl = xpxBaseUrl + "/plugins/servlet/notifications-miniview",
            displayNumber = 0,
            showMiniview = /[?&]show-miniview/.test(window.location.search);

        function getParameterByName(name) {
            name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
            var regexS = "[\\?\\#&]" + name + "=([^&#]*)";
            var regex = new RegExp(regexS);
            var results = regex.exec(window.location.search);
            if(results !== null) {
                return decodeURIComponent(results[1].replace(/\+/g, " "));
            }
        }

        var aggregateKey = getParameterByName('show-miniview');
        if (aggregateKey) {
            notificationsIframeUrl += '#notification/' + aggregateKey;
        }

        function makeAnchor() {
            var iconClass = "badge-i aui-icon aui-icon-small aui-iconfont-workbox-empty";
            MW.$('#notifications-anchor')
                .html('<div class="' + iconClass + '"></div><span class="badge-w"><span class="badge"></span></span>')
                .attr('title', AJS.I18n.getText("com.atlassian.mywork.anchor.tooltip.open"));
        }

        function once(f) {
            var b = false, result;
            return function () {
                if (b) {
                    return result;
                }
                b = true;
                result = f.apply(this, arguments);
                return result;
            };
        }

        var preloadIFrame = once(function() {
            // setting closeOthers to false here because preloading the iframe will close any feature discovery
            // dialogs which are open
            MW.Dialog.getOptions().closeOthers = false;
            MW.Dialog.preload = true;
            MW.Dialog.show();
            MW.Dialog.hide();
            // setting closeOthers to true, which is the default, because once the iframe is preloaded, we always
            // want opening the workbox to close any open inline dialogs
            MW.Dialog.getOptions().closeOthers = true;
        });

        function getFormattedNumber(number) {
            return number <= 9 ? number : '9+';
        }

        function updateNotificationCount(newNotificationCount) {
            // Notifications
            var $notificationsAnchor = MW.$("#notifications-anchor"),
                $notificationsBadge = $notificationsAnchor.find(".badge"),
                $notificationsIcon = $notificationsAnchor.find('.aui-icon');
            $notificationsBadge.html(getFormattedNumber(newNotificationCount));
            displayNumber = newNotificationCount;
            if (newNotificationCount > 0) {
                $notificationsAnchor.addClass("unread").removeClass("read");
                $notificationsIcon.addClass("aui-iconfont-workbox").removeClass("aui-iconfont-workbox-empty");
                if ($notificationsAnchor.is(":visible") && !showMiniview) {
                    preloadIFrame();
                }
            } else {
                $notificationsAnchor.addClass("read").removeClass("unread");
                $notificationsIcon.addClass("aui-iconfont-workbox-empty").removeClass("aui-iconfont-workbox");
            }
        }

        function createIFrame()
        {
            addMiniPopup("notifications", notificationsIframeUrl);
            escapeHidesDialog();
        }

        function escapeHidesDialog() {
            MW.$(document).keydown(function(e) {
                if (AJS.InlineDialog.current && e.which == 27 && !MW.$(e.target).is(":input")) {
                    AJS.InlineDialog.current.hide();
                }
            });
        }

        function hideOpenMenuItems() {
            MW.$("#header-menu-bar").find(".ajs-drop-down").each(function() {
                this.hide();
            });
        }

        function addMiniPopup(id, url)
        {
            var popupFunctions;
            var initCallback = function() {
                popupFunctions = this;
            };

            var hideCallback = function() {
                // Mark all notifications as read when user dismisses the Workbox
                if (this.preload !== true) {
                    var markAllReadMsg = JSON.stringify({markAllRead: true});
                    MW.$('#' + id + '-miniview-iframe')[0].contentWindow.postMessage(markAllReadMsg, "*");
                }
            };

            // Listen for messages from the child iframe
            // escKey: Check if the esc key was pressed from within the iframe
            if (!window.addEventListener) {
                window.attachEvent("onmessage", handleEvent);
            } else {
                window.addEventListener("message", handleEvent, false);
            }

            function handleEvent(e) {
                function sameOrigin(origin) {
                    return origin === location.protocol + '//' + location.host;
                }

                if ("escKey" === e.data) {
                    popupFunctions.hide();
                    // Move the focus OUT of the dialog's iframe to main frame
                    // by focusing on something focusable in the main frame.
                    // This seems to be the only way to change focus between
                    // windows in Firefox.
                    MW.$('#notifications-anchor').focus();
                    // We don't want to keep the anchor activated though
                    document.activeElement.blur();
                } else if ("getParentConfig" === e.data && sameOrigin(e.origin)) {
                    var getParentConfigMsg = JSON.stringify({
                        parentConfig: {
                            parentUrl: location.href,
                            preload: MW.Dialog.preload,
                            unread: displayNumber
                        }
                    }),
                        contentWindow = MW.$('#' + id + '-miniview-iframe')[0].contentWindow;
                    contentWindow.postMessage(getParentConfigMsg, "*");
                    if (MW.Dialog.preload) {
                        MW.Dialog.preload = false;
                    } else {
                        contentWindow.focus();
                    }
                }
            }

            MW.Dialog = AJS.InlineDialog(MW.$("#" + id + "-anchor"), id + '-miniview', function(content, trigger, showPopup) {
                if (MW.$(content).children().length === 0) {
                    MW.$(content).append(MW.$('<iframe id="' + id + '-miniview-iframe" src="' + url + '" frameborder="0"></iframe>'));
                } else {
                    var unreadMsg = JSON.stringify({unread: displayNumber}),
                        contentWindow = MW.$('#' + id + '-miniview-iframe')[0].contentWindow;
                    contentWindow.postMessage(unreadMsg, "*");

                    setTimeout(function() {
                        contentWindow.focus();
                    }, 100);
                }

                hideOpenMenuItems();
                showPopup();

            }, {width: 500, height: 520, hideDelay: null, initCallback: initCallback, hideCallback: hideCallback, noBind: true});

            MW.Tasks = (function() {

                var dialogWidth = 300;
                var dialogPadding = 20;
                var arrowWidth = 16;
                var flyout;

                var $userMenuTrigger = AJS.$("#user-menu-link");
                var $userMenu = AJS.$("#user-menu-link-content");
                var $myTasksLink = $userMenu.find("#view-mytasks-link");

                var dialogLoadOverride = function (content, trigger, showPopup) {
                    var html = MyWork.Templates.Anchor.tasksFeatureDiscovery({
                        tasksUrl: AJS.contextPath() + "/plugins/inlinetasks/mytasks.action"
                    });
                    content.html(html);
                    content.find("#mw-tasks-discovery-dismiss").click(function (){
                        flyout.hide();
                    });
                    showPopup();
                };

                var closeAndDiscoverMyTasks = function() {
                    MW.Dialog.hide();

                    var isProfileMenuOpen = function () {
                        return $userMenu.is(":visible");
                    };

                    if (!isProfileMenuOpen()) {
                        $userMenuTrigger.trigger("aui-button-invoke");
                    }

                    var closeFeatureDiscovery = function () {
                        flyout.hide();
                    };

                    $userMenu.one("aui-dropdown2-hide", closeFeatureDiscovery);

                    flyout = AJS.InlineDialog($myTasksLink, 'my-tasks-discovery', dialogLoadOverride, {
                        hideCallback:function() {
                            flyout.unbind("click focusin mousedown", preventUserProfileClose);
                            $userMenu.unbind("aui-dropdown2-hide", closeFeatureDiscovery);
                            if (isProfileMenuOpen()) {
                                $userMenuTrigger.trigger("aui-button-invoke");
                            }
                            MW.$("#inline-dialog-my-tasks-discovery").remove();
                        },
                        gravity: 'w',
                        useLiveEvents:true,
                        width: dialogWidth,
                        noBind: true
                    });

                    $userMenu.find(".user-item.active").removeClass("active");
                    $myTasksLink.addClass("active");
                    $myTasksLink.focus();

                    var preventUserProfileClose = function (e) {
                        // For the time being, this is the only way to prevent
                        // clicks inside the flyout from closing the user menu dialog2
                        e.stopPropagation();
                    };

                    flyout.on("click focusin mousedown", preventUserProfileClose);

                    flyout.show();
                };

                return {
                    closeAndDiscoverMyTasks: closeAndDiscoverMyTasks
                };
            })();

            // Handle opening the dialog ourselves so the trigger can act as a toggle
            MW.$("#" + id + "-anchor").click(function(e) {
                e.preventDefault();
                if (MW.$('#' + id + '-miniview-iframe').is(':visible')) {
                    MW.Dialog.hide();
                } else {
                    MW.Dialog.show();
                }
            });

            if (showMiniview) {
                MW.$("#" + id + "-anchor").click();
            }
        }

        function setupAnchors()
        {
            makeAnchor();
            createIFrame();
        }

        return {
            setupAnchors: setupAnchors,
            updateNotificationCount: updateNotificationCount
        };
    }();

    MW.MV.AnchorManager.setupAnchors();
    var anchorUtil = new MW.AnchorUtil(MW.$, contextPath, MW.MV.AnchorManager.updateNotificationCount);
    anchorUtil.setupAnchors();

    MW.$("#notifications-anchor").click(function () {
        AJS.trigger('analytics', { name: 'mywork.host.button.clicked.notifications', data: {} });
        MW.MV.AnchorManager.updateNotificationCount(0);
    });

    var handleVisibilityChange = function () {
        if (document.hidden) {
            anchorUtil.stopRequests(true);
        } else  {
            anchorUtil.startRequests();
        }
    };
    document.addEventListener("visibilitychange", handleVisibilityChange, false);

    if (typeof document.hidden === "undefined") {
       MW.$(window).focus(function () {
           anchorUtil.startRequests();
       });
    }

    MW.$('body').click(function () {
        anchorUtil.startRequests();
    });
});
