/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.batch;

import com.atlassian.mywork.host.dao.TaskDao;
import com.atlassian.sal.api.scheduling.PluginJob;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCleanerTask
implements PluginJob {
    private static final int DAYS_TO_KEEP = 7;
    private static final Logger log = LoggerFactory.getLogger(TaskCleanerTask.class);

    public void execute(Map<String, Object> jobDataMap) {
        final TaskDao taskDao = (TaskDao)jobDataMap.get(TaskDao.class.getName());
        TransactionTemplate transactionTemplate = (TransactionTemplate)jobDataMap.get(TransactionTemplate.class.getName());
        transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                int count = taskDao.deleteOldCompletedTasks(7);
                log.info("Deleted {} old tasks", (Object)count);
                return count;
            }
        });
    }
}

