/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xhtml.parsing;

import com.atlassian.xhtml.parsing.IsolatedBodyListener;
import com.atlassian.xhtml.parsing.SelfClosingTagPreservingHTMLTagBalancer;
import java.util.HashSet;
import java.util.Set;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;

public class BlockIsolatingTagBalancer
extends SelfClosingTagPreservingHTMLTagBalancer
implements IsolatedBodyListener {
    private Set<String> elementsToIsolate = new HashSet<String>(2);
    private BlockIsolatingTagBalancer delegateBalancer;
    private String delegatingForRawName;
    private IsolatedBodyListener listener;

    public BlockIsolatingTagBalancer(Set<String> elementRawNamesToIsolate) {
        this.elementsToIsolate = elementRawNamesToIsolate;
    }

    public void startElement(QName elem, XMLAttributes attrs, Augmentations augs) throws XNIException {
        if (this.delegateBalancer != null) {
            this.delegateBalancer.startElement(elem, attrs, augs);
        } else if (this.elementsToIsolate.contains(elem.rawname)) {
            this.delegateBalancer = this.constructNew();
            this.delegateBalancer.setDelegatingForRawName(elem.rawname);
            super.startElement(elem, attrs, augs);
        } else {
            super.startElement(elem, attrs, augs);
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this.delegateBalancer != null) {
            this.delegateBalancer.endElement(element, augs);
        } else if (this.delegatingForRawName != null && element.rawname.equals(this.delegatingForRawName)) {
            this.listener.completeForEndElement(element, augs);
            this.listener = null;
        } else {
            super.endElement(element, augs);
        }
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        if (this.delegateBalancer != null) {
            this.delegateBalancer.xmlDecl(version, encoding, standalone, augs);
        } else {
            super.xmlDecl(version, encoding, standalone, augs);
        }
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (this.delegateBalancer != null) {
            this.delegateBalancer.comment(text, augs);
        } else {
            super.comment(text, augs);
        }
    }

    @Override
    public void emptyElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        if (this.delegateBalancer != null) {
            this.delegateBalancer.emptyElement(element, attrs, augs);
        } else {
            super.emptyElement(element, attrs, augs);
        }
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier id, String encoding, Augmentations augs) throws XNIException {
        if (this.delegateBalancer != null) {
            this.delegateBalancer.startGeneralEntity(name, id, encoding, augs);
        } else {
            super.startGeneralEntity(name, id, encoding, augs);
        }
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        if (this.delegateBalancer != null) {
            this.delegateBalancer.textDecl(version, encoding, augs);
        } else {
            super.textDecl(version, encoding, augs);
        }
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        if (this.delegateBalancer != null) {
            this.delegateBalancer.endGeneralEntity(name, augs);
        } else {
            super.endGeneralEntity(name, augs);
        }
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        if (this.delegateBalancer != null) {
            this.delegateBalancer.endCDATA(augs);
        } else {
            super.endCDATA(augs);
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.delegateBalancer != null) {
            this.delegateBalancer.characters(text, augs);
        } else {
            super.characters(text, augs);
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        if (this.delegateBalancer != null) {
            this.delegateBalancer.processingInstruction(target, data, augs);
        } else {
            super.processingInstruction(target, data, augs);
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (this.delegateBalancer != null) {
            this.delegateBalancer.ignorableWhitespace(text, augs);
        } else {
            super.ignorableWhitespace(text, augs);
        }
    }

    public void setDelegatingForRawName(String delegatingForRawName) {
        this.delegatingForRawName = delegatingForRawName;
    }

    public void setListener(IsolatedBodyListener listener) {
        this.listener = listener;
    }

    @Override
    public void completeForEndElement(QName element, Augmentations augs) throws XNIException {
        this.delegateBalancer = null;
        super.endElement(element, augs);
    }

    protected BlockIsolatingTagBalancer constructNew() {
        BlockIsolatingTagBalancer isolatedTagBalancer = new BlockIsolatingTagBalancer(this.elementsToIsolate);
        isolatedTagBalancer.setDocumentHandler(this.getDocumentHandler());
        isolatedTagBalancer.setDocumentSource(this.getDocumentSource());
        isolatedTagBalancer.fErrorReporter = this.fErrorReporter;
        isolatedTagBalancer.tagBalancingListener = this.tagBalancingListener;
        isolatedTagBalancer.fNamespaces = this.fNamespaces;
        isolatedTagBalancer.fAugmentations = this.fAugmentations;
        isolatedTagBalancer.fReportErrors = this.fReportErrors;
        isolatedTagBalancer.fDocumentFragment = this.fDocumentFragment;
        isolatedTagBalancer.fIgnoreOutsideContent = this.fIgnoreOutsideContent;
        isolatedTagBalancer.fNamesElems = this.fNamesElems;
        isolatedTagBalancer.fNamesAttrs = this.fNamesAttrs;
        isolatedTagBalancer.setListener(this);
        return isolatedTagBalancer;
    }
}

