/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.batch;

import com.atlassian.mywork.host.dao.NotificationDao;
import com.atlassian.sal.api.scheduling.PluginJob;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationCleanerTask
implements PluginJob {
    private static final int DAYS_TO_KEEP = 14;
    private static final int DAYS_TO_KEEP_UNREAD = 28;
    private static final Logger log = LoggerFactory.getLogger(NotificationCleanerTask.class);

    public void execute(Map<String, Object> jobDataMap) {
        final NotificationDao notificationDao = (NotificationDao)jobDataMap.get(NotificationDao.class.getName());
        TransactionTemplate transactionTemplate = (TransactionTemplate)jobDataMap.get(TransactionTemplate.class.getName());
        transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                log.info("Deleted {} old notifications", (Object)notificationDao.deleteOldNotifications(14, true));
                log.info("Deleted {} old unread notifications", (Object)notificationDao.deleteOldNotifications(28, false));
                return null;
            }
        });
    }
}

