// The Header for the drilldown view
MW.HeaderAbstractView = Backbone.View.extend({

    events: {
        "click .mw-task": "selectTask"
        },

    initialize: function(options) {
        this.globalEvents = options.globalEvents;
    },

    removeBindings: function() {
        this.$el.unbind();
        this.model.off(null, null, this);
    },

    render: function() {
        var $el = MW.$(this.options.el),
            notificationGroup = this.options.model,
            htmlTitle = this.htmlTitle();

        if (!htmlTitle) {
            return; // Nothing to render
        }

        // Render task link only if:
        //  * all notification share the same globalId, or
        //  * this is not an inline task notification, or
        //  * it is not pinned
        var renderTask = notificationGroup.has('globalId') &&
                         !(notificationGroup.get("application") === "com.atlassian.mywork.providers.confluence" && notificationGroup.get("action").indexOf("task.") === 0) &&
                         !notificationGroup.get("pinned");
        // Bit of a hack - we need a different header for mobile (we really need sep js files for mobile views: WDAY-726)
        var headerAttributes = MW.$.extend({}, notificationGroup.attributes, {title: htmlTitle, newActionsText: this.newActionsText(), renderTask: renderTask, hasTask: notificationGroup.hasTask()});
        this.renderTemplate($el, headerAttributes, notificationGroup);

        // Object Actions
        this.addActions();
    },

    htmlTitle: function() {
        var notifications = this.model.notifications,
            metadata = notifications[0].get('metadata');
        return this.model.i18nHtml('itemtitle', metadata) || MW.escapeHTML(this.model.get("title"));
    },

    newActionsText: function() {
        var notificationGroup = this.options.model,
            numUpdates = this.options.numUpdates,
            thisMsg = notificationGroup.entityI18n("this") || AJS.I18n.getText('com.atlassian.mywork.this'),
            entityMsg = notificationGroup.entityI18n("entity") || notificationGroup.get('entity'),
            entity = thisMsg + ' ' + entityMsg,
            newActionsText = notificationGroup.i18ns("aggregatenew", numUpdates, entity);
        if (numUpdates === 0) {
            newActionsText = notificationGroup.i18ns("aggregate", notificationGroup.notifications.length, entity);
        }
        return newActionsText;
    },

    addActions: function() {
        var that = this,
            notificationGroup = this.model,
            firstNotification = this.model.notifications[0],
            $el = MW.$(this.options.el);

        var $actionElement = MW.$(".drilldown-header-title > .mw-drilldown-actions"),
            $headerActions = $el.find(".mw-drilldown-actions > ul");

        var actionMessageView = new MW.ActionMessageView({
            el: $el.find('.message').first(),
            aggregateKey: notificationGroup.get('aggregateKey')
        });

        // TODO: really shouldn't need 'firstNotification' for object actions (should be on the notificationGroup itself)
        _.each(notificationGroup.get("objectActions"), function(action) {
            var objectActions = new MW.ActionView({
                model: action,
                url: notificationGroup.get("url"),
                itemUrl: notificationGroup.get("url"),
                actionFormElement: $el.find('.action-form'),
                notification: firstNotification,
                actions: notificationGroup.get("objectActions"),
                actionMessageView: actionMessageView,
                target: "object",
                actionElement: $actionElement,
                globalEvents: that.globalEvents
            });

            $headerActions.append(objectActions.render().el);
        });
    },

    selectTask: function() {
        if (this.model.hasTask()) {
            this.globalEvents.trigger("showTaskByGlobalId", this.model.get('globalId'));
        } else {
            this.createTask();
        }
    },

    _getRelatedTaskButton: function () {
        return MW.$(this.options.el).find('.drilldown-task-container .mw-task');
    },

    createTask: function() {
        this._getRelatedTaskButton().addClass('loading');
        this.model.createTask(_.bind(this.taskCreated, this));
    },

    taskCreated: function() {
        this._getRelatedTaskButton().removeClass('loading').addClass("on");
    }
});