var MW = MW || { $ : AJS.$ || Zepto };

MW.Cookie = (function() { return {
    name: 'mywork.tab.tasks',
    save: function(tasksOn) {
        this.setCookie(this.name, tasksOn, 7);
    },
    load: function() {
        return this.getCookie(this.name) == 'true';
    },
    setCookie: function(name, value, days) {
        var expires = "";
        if (days) {
            var date = new Date();
            date.setTime(date.getTime()+ (days * 24 * 60 * 60 * 1000));
            expires = "; expires=" + date.toGMTString();
        }
        document.cookie = name + "=" + value + expires + "; path=/";
    },
    getCookie: function(name) {
        var nameEQ = name + "=";
        var ca = document.cookie.split('; ');
        for(var i=0; i < ca.length; i++) {
            if (ca[i].indexOf(nameEQ) === 0) {
                return ca[i].substring(nameEQ.length, ca[i].length);
            }
        }
        return null;
    }
};})();


MW.Slide = {
    FROM_RIGHT : "from-right",
    FROM_LEFT : "from-left"
};

MW.CardTransitions = (function(options){
    var globalEvents;

    var initialize = function(options) {
        globalEvents = options.globalEvents;
    };

    var showCard = function(cardToShow, slideType, slideTime, callback){
        slideTime = slideTime || 300;
        var showDirection, hideDirection;
        if (slideType === MW.Slide.FROM_RIGHT) {
            showDirection = "right";
            hideDirection = "left";
        } else if (slideType === MW.Slide.FROM_LEFT) {
            showDirection = "left";
            hideDirection = "right";
        } else {
            showDirection = hideDirection = "";
        }

        var cardToHide = MW.$(".showing");
        MW.$(".transition-finished").removeClass("transition-finished");
        setTimeout(function(){
            globalEvents.trigger('blockKeyboardShortcut');

            // Transition classes for webdriver tests
            cardToShow.addClass("showing");
            cardToShow.show('slide', {direction: showDirection}, slideTime, function(){
                globalEvents.trigger('unblockKeyboardShortcut');
                // MW.App.scrollToFocusedMain(); for notifications!
                cardToShow.focus(); // for IE9
                cardToShow.addClass('transition-finished');
            });

            // This can happen in Firefox on initial double-load
            if (cardToHide.length > 0 && cardToHide[0] == cardToShow[0]) {
                if (callback) {
                    callback();
                }
                return;
            }
            // Hide the currently visible card
            cardToHide.removeClass("showing");
            cardToHide.hide('slide', {direction: hideDirection}, slideTime, function(){
                globalEvents.trigger('cleanupNestedCard');

                if (callback) {
                    callback();
                }
            });
        });
    };

    initialize(options);

    return {
        showCard: showCard
    };
});

// Taken from JQuery UI Effects as missing in the current AUI
MW.$(function($) {
    (function($, undefined ) {
        MW.$.effects.slide = function(o) {

            return this.queue(function() {

                // Create element
                var el = MW.$(this), props = ['position','top','bottom','left','right'];

                // Set options
                var mode = MW.$.effects.setMode(el, o.options.mode || 'show'); // Set Mode
                var direction = o.options.direction || 'left'; // Default Direction

                // Adjust
                MW.$.effects.save(el, props); el.show(); // Save & Show
                MW.$.effects.createWrapper(el).css({overflow:'hidden'}); // Create Wrapper
                var ref = (direction == 'up' || direction == 'down') ? 'top' : 'left';
                var motion = (direction == 'up' || direction == 'left') ? 'pos' : 'neg';
                var distance = o.options.distance || (ref == 'top' ? el.outerHeight({margin:true}) : el.outerWidth({margin:true}));
                if (mode == 'show') el.css(ref, motion == 'pos' ? (isNaN(distance) ? "-" + distance : -distance) : distance); // Shift

                // Animation
                var animation = {};
                animation[ref] = (mode == 'show' ? (motion == 'pos' ? '+=' : '-=') : (motion == 'pos' ? '-=' : '+=')) + distance;

                // Animate
                el.animate(animation, { queue: false, duration: o.duration, easing: o.options.easing, complete: function() {
                    if(mode == 'hide') el.hide(); // Hide
                    MW.$.effects.restore(el, props); $.effects.removeWrapper(el); // Restore
                    if(o.callback) o.callback.apply(this, arguments); // Callback
                    el.dequeue();
                }});

            });

        };
    })(AJS.$);
});
