/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.client.service;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.VCacheUtils;
import com.atlassian.vcache.marshallers.MarshallerFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
class HostIdCache {
    private static final Logger log = LoggerFactory.getLogger(HostIdCache.class);
    private final Supplier<StableReadExternalCache<Option<String>>> cacheRef;

    public HostIdCache(VCacheFactory cacheFactory, String cacheName) {
        this((Supplier<StableReadExternalCache<Option<String>>>)Lazy.supplier(() -> HostIdCache.createCache(cacheFactory, cacheName)));
    }

    @VisibleForTesting
    HostIdCache(Supplier<StableReadExternalCache<Option<String>>> cacheRef) {
        this.cacheRef = cacheRef;
    }

    private static StableReadExternalCache<Option<String>> createCache(VCacheFactory cacheFactory, String cacheName) {
        return cacheFactory.getStableReadExternalCache(cacheName, MarshallerFactory.serializableMarshaller(Option.class), new ExternalCacheSettingsBuilder().build());
    }

    public void setHost(String hostKey, Option<ApplicationId> host) {
        Option appId = host.map(ApplicationId::get);
        log.debug("Setting cached {} to {}", (Object)hostKey, (Object)appId);
        VCacheUtils.fold((CompletionStage)((StableReadExternalCache)this.cacheRef.get()).put(hostKey, (Object)appId, PutPolicy.PUT_ALWAYS), Function.identity(), ex -> {
            log.error("Failed to put host into cache", ex);
            throw Throwables.propagate((Throwable)ex);
        });
    }

    @Nullable
    public Option<ApplicationId> getHost(String hostKey) {
        return (Option)VCacheUtils.fold((CompletionStage)((StableReadExternalCache)this.cacheRef.get()).get(hostKey), hostId -> hostId.map(x -> x.map(ApplicationId::new)).orElse(null), ex -> {
            log.warn("Failed to retrieve host from cache", ex);
            return null;
        });
    }

    public void clear() {
        VCacheUtils.fold((CompletionStage)((StableReadExternalCache)this.cacheRef.get()).removeAll(), (x, ex) -> {
            if (ex != null) {
                log.error("Failed to clear cache", ex);
                throw Throwables.propagate((Throwable)ex);
            }
            return null;
        });
    }
}

