/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.client.servlet;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.auth.ImpersonatingAuthenticationProvider;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.mywork.client.ClientUtil;
import com.atlassian.mywork.service.HostService;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private final transient UserManager userManager;
    private final transient LoginUriProvider loginUriProvider;
    private final transient HostApplication hostApplication;
    private final transient TemplateRenderer templateRenderer;
    private final transient HostService hostService;

    public AuthenticationServlet(UserManager userManager, LoginUriProvider loginUriProvider, HostApplication hostApplication, TemplateRenderer templateRenderer, HostService hostService) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.hostApplication = hostApplication;
        this.templateRenderer = templateRenderer;
        this.hostService = hostService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = this.userManager.getRemoteUsername(req);
        if (username == null) {
            String queryString = req.getQueryString() != null ? '?' + req.getQueryString() : "";
            URI loginUri = this.loginUriProvider.getLoginUri(URI.create(req.getRequestURL().append(queryString).toString()));
            resp.sendRedirect(loginUri.toASCIIString());
            return;
        }
        Iterator i$ = this.hostService.getActiveHost().iterator();
        if (i$.hasNext()) {
            ApplicationLink applicationLink = (ApplicationLink)i$.next();
            String origin = req.getParameter("origin");
            if (origin == null || applicationLink.getId().get().equals(origin)) {
                this.doGet(req, resp, applicationLink);
                return;
            }
            throw new ServletException("Request did not originate from the configured host '" + applicationLink.getDisplayUrl() + "'");
        }
        throw new ServletException("Host is not configured");
    }

    private void doGet(HttpServletRequest req, HttpServletResponse resp, ApplicationLink applicationLink) throws ServletException, IOException {
        String callBackUrl = req.getParameter("callback");
        if (ClientUtil.credentialsRequired(applicationLink, this.hostApplication.getId())) {
            String authServletUrl = callBackUrl != null ? AuthenticationServlet.appendRelativePath(applicationLink.getDisplayUrl(), callBackUrl) : this.hostApplication.getBaseUrl() + "/plugins/servlet/myworkauth";
            ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory(ImpersonatingAuthenticationProvider.class);
            resp.sendRedirect(requestFactory.getAuthorisationURI(URI.create(authServletUrl)).toString());
        } else if (callBackUrl != null) {
            resp.sendRedirect(AuthenticationServlet.appendRelativePath(applicationLink.getDisplayUrl(), callBackUrl));
        } else {
            resp.setContentType("text/html; charset=UTF-8");
            ImmutableMap context = ImmutableMap.of((Object)"writer", (Object)resp.getWriter(), (Object)"urlMode", (Object)UrlMode.RELATIVE);
            this.templateRenderer.render("templates/authentication-completed.vm", (Map)context, (Writer)resp.getWriter());
        }
    }

    protected static String appendRelativePath(URI uri, String path) {
        URI extra = URI.create(path);
        String result = uri.resolve(extra.getPath() + (extra.getRawQuery() != null ? "?" + extra.getRawQuery() : "")).toASCIIString();
        int fragmentIndex = path.indexOf(35);
        return result + (fragmentIndex == -1 ? "" : path.substring(fragmentIndex));
    }
}

