package com.atlassian.multitenant.spring;

import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Node;

/**
 * This decorator does nothing, the MultiTenantStatefulBeanDefinitionDecorator looks for the attribute decorated by
 * this class and handles it accordingly
 */
public class MultiTenantLazyLoadedBeanDefinitionDecorator implements BeanDefinitionDecorator
{
    public BeanDefinitionHolder decorate(final Node node, final BeanDefinitionHolder definition,
            final ParserContext parserContext)
    {
        return definition;
    }
}
