/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.spring;

import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantComponentMapBuilder;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.MultiTenantDestroyer;
import com.atlassian.multitenant.Tenant;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ClassUtils;

public class MultiTenantFactoryBean
implements FactoryBean,
ApplicationContextAware,
BeanNameAware {
    private static final Logger log = Logger.getLogger(MultiTenantFactoryBean.class);
    private Class[] interfaces;
    private Class implementation;
    private FactoryBean factory;
    private boolean lazyLoad = true;
    private Object proxy;
    private ApplicationContext applicationContext;
    private String name;
    private String targetName;

    public MultiTenantFactoryBean() {
        System.out.println("Break me");
    }

    public synchronized Object getObject() throws Exception {
        if (this.proxy == null) {
            MultiTenantComponentMapBuilder builder = MultiTenantContext.getFactory().createComponentMapBuilder((MultiTenantCreator)new FactoryBeanCreator());
            if (!this.lazyLoad) {
                builder.setLazyLoad(MultiTenantComponentMap.LazyLoadStrategy.EAGER_LOAD);
            }
            MultiTenantComponentMap map = builder.construct();
            if (this.getImplementingInterfaces() != null && this.getImplementingInterfaces().length > 0) {
                Set<Object> invokeForAllMethods = this.isApplicationListener() ? Collections.singleton(ApplicationListener.class.getDeclaredMethod("onApplicationEvent", ApplicationEvent.class)) : Collections.emptySet();
                this.proxy = MultiTenantContext.getFactory().createComponent(map, this.implementation.getClassLoader(), invokeForAllMethods, this.getImplementingInterfaces());
            } else {
                this.proxy = MultiTenantContext.getFactory().createEnhancedComponent(map, this.implementation);
            }
        }
        return this.proxy;
    }

    private boolean isApplicationListener() {
        for (Class clazz : this.getImplementingInterfaces()) {
            if (!clazz.equals(ApplicationListener.class)) continue;
            return true;
        }
        return false;
    }

    private Class[] getImplementingInterfaces() {
        if (this.interfaces == null) {
            if (this.implementation == null) {
                this.interfaces = new Class[0];
            } else {
                if (FactoryBean.class.isAssignableFrom(this.implementation)) {
                    try {
                        this.factory = (FactoryBean)this.implementation.newInstance();
                        this.implementation = this.factory.getObjectType();
                        if (this.implementation == null) {
                            throw new IllegalArgumentException("FactoryBean can only be stateful if it returns an object type");
                        }
                    }
                    catch (InstantiationException e) {
                        throw new IllegalArgumentException("FactoryBean can only be stateful if it can be instantiated witha noarg constructor", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalArgumentException("FactoryBean can only be stateful if it can be instantiated witha noarg constructor", e);
                    }
                }
                this.interfaces = this.implementation.getInterfaces();
            }
        }
        return this.interfaces;
    }

    public Class getObjectType() {
        if (this.getImplementingInterfaces() == null && this.getImplementingInterfaces().length == 0) {
            return this.implementation;
        }
        if (this.getImplementingInterfaces().length == 1) {
            return this.getImplementingInterfaces()[0];
        }
        return ClassUtils.createCompositeInterface((Class[])this.getImplementingInterfaces(), (ClassLoader)this.implementation.getClassLoader());
    }

    public boolean isSingleton() {
        return true;
    }

    public void setInterfaces(Class[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setImplementation(Class implementation) {
        this.implementation = implementation;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FactoryBeanCreator
    implements MultiTenantCreator<Object>,
    MultiTenantDestroyer<Object> {
        private FactoryBeanCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object create(Tenant tenant) {
            boolean contextSet = false;
            if (!MultiTenantFactoryBean.this.lazyLoad && !MultiTenantContext.getTenantReference().isSet()) {
                contextSet = true;
                MultiTenantContext.getTenantReference().set(tenant, true);
            }
            try {
                if (MultiTenantFactoryBean.this.targetName != null) {
                    Object object = MultiTenantFactoryBean.this.applicationContext.getBean(MultiTenantFactoryBean.this.targetName);
                    return object;
                }
                if (MultiTenantFactoryBean.this.factory != null) {
                    try {
                        Object object = MultiTenantFactoryBean.this.factory.getObject();
                        return object;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Exception thrown while trying to instantiate " + MultiTenantFactoryBean.this.name + " from factory", e);
                    }
                }
                Object object = MultiTenantFactoryBean.this.applicationContext.getAutowireCapableBeanFactory().createBean(MultiTenantFactoryBean.this.implementation, 4, false);
                return object;
            }
            finally {
                if (contextSet) {
                    MultiTenantContext.getTenantReference().remove();
                }
            }
        }

        public void destroy(Tenant tenant, Object instance) {
            if (instance instanceof DisposableBean) {
                try {
                    ((DisposableBean)instance).destroy();
                }
                catch (Exception e) {
                    log.error((Object)("Exception thrown while disposing bean " + MultiTenantFactoryBean.this.name + " for tenant " + tenant.getName()));
                }
            }
        }
    }
}

