/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.cache.MultiTenantCacheKey;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedMultiTenantCacheManager
implements CacheManager {
    private final CacheManager delegate;
    private final Map<String, Cache> caches = CopyOnWriteMap.newHashMap();
    private final Set<Object> sharedCaches;

    public SharedMultiTenantCacheManager(CacheManager delegate, Set<Object> sharedCaches) {
        this.delegate = delegate;
        this.sharedCaches = sharedCaches;
    }

    public Collection getCaches() {
        return this.delegate.getCaches();
    }

    public void flushCaches() {
        this.delegate.flushCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(String name) {
        Object cache = this.caches.get(name);
        if (cache == null) {
            SharedMultiTenantCacheManager sharedMultiTenantCacheManager = this;
            synchronized (sharedMultiTenantCacheManager) {
                if (!this.caches.containsKey(name)) {
                    cache = this.sharedCaches.contains(name) ? this.delegate.getCache(name) : new SharedMultiTenantCache(name);
                    this.caches.put(name, (Cache)cache);
                }
            }
        }
        return cache;
    }

    private class SharedMultiTenantCache
    implements Cache {
        private final String name;
        private final Cache cache;

        private SharedMultiTenantCache(String name) {
            this.name = name;
            this.cache = SharedMultiTenantCacheManager.this.delegate.getCache(name);
        }

        public String getName() {
            return this.name;
        }

        public Collection getKeys() {
            ArrayList<MultiTenantCacheKey> results = new ArrayList<MultiTenantCacheKey>();
            String tenant = MultiTenantContext.getTenantReference().get().getName();
            for (MultiTenantCacheKey key : this.cache.getKeys()) {
                if (!key.getTenant().equals(tenant)) continue;
                results.add(key);
            }
            return results;
        }

        public Object get(Object key) {
            return this.cache.get((Object)this.createKey(key));
        }

        public void put(Object key, Object value) {
            this.cache.put((Object)this.createKey(key), value);
        }

        public void remove(Object key) {
            this.cache.remove((Object)this.createKey(key));
        }

        public void removeAll() {
            String tenant = MultiTenantContext.getTenantReference().get().getName();
            for (MultiTenantCacheKey key : this.cache.getKeys()) {
                if (!key.getTenant().equals(tenant)) continue;
                this.cache.remove((Object)key);
            }
        }

        private MultiTenantCacheKey createKey(Object key) {
            return new MultiTenantCacheKey(MultiTenantContext.getTenantReference().get().getName(), key);
        }
    }
}

