package com.atlassian.multitenant.spring;

import com.atlassian.multitenant.MultiTenantContext;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/**
 * Spring definition parser for providing two alternative implementations of a bean, one for multi tenant, one for
 * single tenant.
 */
public class MultiTenantAlternativeBeanDefinitionParser extends AbstractBeanDefinitionParser
{
    protected AbstractBeanDefinition parseInternal(final Element element, final ParserContext parserContext)
    {
        Element bean;
        if (MultiTenantContext.isEnabled())
        {
            bean = (Element) element.getElementsByTagNameNS(MultiTenantNamespaceHandler.NAMESPACE, "multitenant-bean").item(0);
        }
        else
        {
            bean = (Element) element.getElementsByTagNameNS(MultiTenantNamespaceHandler.NAMESPACE, "singletenant-bean").item(0);
        }
        // We need a containing bean because this bean may not have a name
        RootBeanDefinition containingBean = new RootBeanDefinition();
        containingBean.setSingleton(true);
        BeanDefinitionHolder holder = parserContext.getDelegate().parseBeanDefinitionElement(bean, containingBean);
        // The holder only has BeanDefinition types, but we need to return AbstractBeanDefinition.  No worries,
        // BeanDefinitionParserDelegate only even returns holders with AbstractBeanDefinitions in them anyway.
        return (AbstractBeanDefinition) holder.getBeanDefinition();
    }
}
