package com.atlassian.multitenant.osuser;

import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.Tenant;
import com.opensymphony.user.UserManager;
import com.opensymphony.user.UserManagerInstanceProvider;

import java.io.ByteArrayInputStream;

/**
 * UserManager instance provider that returns the correct UserManager for the current tenant.
 */
public class MultiTenantUserManagerInstanceProvider implements UserManagerInstanceProvider
{
    private final MultiTenantComponentMap<UserManager> map = MultiTenantContext.getFactory().createComponentMap(new UserManagerCreator());

    public UserManager getInstance()
    {
        return map.get();
    }

    private static class UserManagerCreator implements MultiTenantCreator<UserManager>
    {
        public UserManager create(final Tenant tenant)
        {
            return new UserManager(new ByteArrayInputStream(
                    MultiTenantContext.getTenantReference().get().getConfig(OsUserMultiTenantConfig.class).getOsUserXml()));
        }
    }

    /**
     * Convenience method for configuring an instance provider
     */
    public static void configureInstanceProvider()
    {
        UserManager.setInstanceProvider(new MultiTenantUserManagerInstanceProvider());
    }
}