package com.atlassian.multitenant.hibernate;

import com.atlassian.multitenant.CustomConfigHandler;
import org.dom4j.Element;

import java.sql.Driver;

/**
 * Handler for parsing Hibernate configuration
 */
public class HibernateXmlCustomConfigHandler implements CustomConfigHandler<HibernateMultiTenantConfig>
{
    public Class<HibernateMultiTenantConfig> getBeanClass()
    {
        return HibernateMultiTenantConfig.class;
    }

    @SuppressWarnings("unchecked")
    public HibernateMultiTenantConfig parse(final Element element)
    {
        String driverClassName = element.elementText("driverClass");
        Class<? extends Driver> driverClass;
        try
        {
            driverClass = (Class<? extends Driver>) Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e)
        {
            throw new RuntimeException(e);
        }
        String databaseUrl = element.elementText("databaseUrl");
        String username = element.elementText("username");
        String password = element.elementText("password");
        int poolSize = Integer.parseInt(element.elementText("poolSize"));
        return new HibernateMultiTenantConfig(driverClass, databaseUrl, username, password, poolSize);
    }

    public void writeTo(final Element element, final HibernateMultiTenantConfig bean)
    {
        element.addElement("driverClass").setText(bean.getDriverClass().getName());
        element.addElement("username").setText(bean.getUsername());
        element.addElement("password").setText(bean.getPassword());
        element.addElement("poolSize").setText(Integer.toString(bean.getPoolSize()));
    }
}
