package com.atlassian.multitenant.cache;

import java.io.Serializable;

public class MultiTenantCacheKey implements Serializable
{
    private final Object key;
    private final String tenant;

    public MultiTenantCacheKey(final String tenant, final Object key)
    {
        this.key = key;
        this.tenant = tenant;
    }

    public Object getKey()
    {
        return key;
    }

    public String getTenant()
    {
        return tenant;
    }

    @Override
    public boolean equals(final Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final MultiTenantCacheKey that = (MultiTenantCacheKey) o;

        if (key != null ? !key.equals(that.key) : that.key != null)
        {
            return false;
        }
        if (tenant != null ? !tenant.equals(that.tenant) : that.tenant != null)
        {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode()
    {
        int result = key != null ? key.hashCode() : 0;
        result = 31 * result + (tenant != null ? tenant.hashCode() : 0);
        return result;
    }
}