package com.atlassian.multitenant.applinks;

import java.util.Collections;
import java.util.Map;

/**
 * A single applink
 */
public class AppLinkConfig
{
    private final String application;
    private final String name;
    private final String url;
    private final Map<String, String> properties;

    public AppLinkConfig(final String application, final String name, final String url, final Map<String, String> properties)
    {
        this.application = application;
        this.name = name;
        this.url = url;
        this.properties = Collections.unmodifiableMap(properties);
    }

    public String getApplication()
    {
        return application;
    }

    public String getName()
    {
        return name;
    }

    public String getUrl()
    {
        return url;
    }

    public Map<String, String> getProperties()
    {
        return properties;
    }
}
