/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.modzdetector.ant;

import com.atlassian.modzdetector.HashRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class GenerateRegistryTask
extends Task {
    private static final Logger log = Logger.getLogger(GenerateRegistryTask.class);
    private List files = new ArrayList();
    private List classes = new ArrayList();
    private String name;

    public void addFilesystem(FileSet f) {
        if (f != null) {
            this.files.add(f);
        }
    }

    public void addClasspath(FileSet f) {
        if (f != null) {
            this.classes.add(f);
        }
    }

    public void setName(String fileName) {
        this.name = fileName;
    }

    public void execute() throws BuildException {
        try {
            HashRegistry hr = this.name != null && this.name.length() > 0 ? new HashRegistry(this.name) : new HashRegistry();
            hr.setClasspathMode();
            this.register(hr, this.classes);
            hr.setFilesystemMode();
            this.register(hr, this.files);
            hr.store();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void register(HashRegistry hr, List filesets) {
        for (int i = 0; i < filesets.size(); ++i) {
            FileSet set = (FileSet)filesets.get(i);
            DirectoryScanner ds = set.getDirectoryScanner(this.getProject());
            String[] fileNames = ds.getIncludedFiles();
            for (int j = 0; j < fileNames.length; ++j) {
                String filename = fileNames[j];
                log.debug((Object)("registering " + filename));
                try {
                    String filenameFixed = filename.replace('\\', '/');
                    hr.register(filenameFixed, new FileInputStream(new File(set.getDir(this.getProject()), filename)));
                    continue;
                }
                catch (FileNotFoundException e) {
                    log.error((Object)("cannot find file " + filename));
                }
            }
        }
    }
}

