/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.MediaTypes;
import com.atlassian.migration.agent.okhttp.ServiceErrorCodeHandler;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.impl.StargateHelper;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.atlassian.migration.app.AppMigrationServiceClient;
import com.atlassian.migration.app.dto.AppsCloudSiteResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.web.util.UriComponentsBuilder;

@Singleton
@ParametersAreNonnullByDefault
public class DefaultAppMigrationServiceClient
implements AppMigrationServiceClient {
    private final HttpService httpService;
    private final MigrationAgentConfiguration configuration;
    private final CloudSiteService cloudSiteService;
    private final boolean bypassStargate;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    @Inject
    public DefaultAppMigrationServiceClient(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor, CloudSiteService cloudSiteService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this(new HttpService(() -> DefaultAppMigrationServiceClient.buildHttpClient(userAgentInterceptor), new ServiceErrorCodeHandler()), configuration, cloudSiteService, migrationDarkFeaturesManager);
    }

    @VisibleForTesting
    DefaultAppMigrationServiceClient(HttpService httpService, MigrationAgentConfiguration configuration, CloudSiteService cloudSiteService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.bypassStargate = configuration.isBypassStargate();
        this.httpService = httpService;
        this.configuration = configuration;
        this.cloudSiteService = cloudSiteService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    private static OkHttpClient buildHttpClient(UserAgentInterceptor userAgentInterceptor) {
        return new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).build();
    }

    public void registerMigration(String cloudId, String migrationId) {
        if (!this.migrationDarkFeaturesManager.appMigrationEnabled()) {
            return;
        }
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path(String.format("/register/%s", migrationId)).toUriString()).put(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)"")).build();
        this.httpService.call(request);
    }

    public UUID registerTransfer(String cloudId, String migrationId, String addOnKey) {
        if (!this.migrationDarkFeaturesManager.appMigrationEnabled()) {
            return null;
        }
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path(String.format("/listener/%s/%s", migrationId, addOnKey)).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)"")).build();
        return this.httpService.callGson(request, UUID.class);
    }

    public Map<String, ?> getMigrationContext(String cloudId, String migrationContextId) {
        if (!this.migrationDarkFeaturesManager.appMigrationEnabled()) {
            return Collections.emptyMap();
        }
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path("/mapping/" + migrationContextId).toUriString()).get().build();
        return this.httpService.callJson(request, new TypeReference<Map>(){});
    }

    public Map<String, ?> getMigrationContext(String cloudId, String migrationContextId, String namespace) {
        if (!this.migrationDarkFeaturesManager.appMigrationEnabled()) {
            return Collections.emptyMap();
        }
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path("/mapping/" + migrationContextId + "/" + namespace).toUriString()).get().build();
        return this.httpService.callJson(request, new TypeReference<Map>(){});
    }

    public Map<String, ?> getMigrationContextNamespaces(String cloudId, String migrationContextId, Set<String> namespaces) {
        if (!this.migrationDarkFeaturesManager.appMigrationEnabled()) {
            return Collections.emptyMap();
        }
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path("/mapping/" + migrationContextId + "/namespace/query").toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)Jsons.valueAsString(namespaces))).build();
        return this.httpService.callJson(request, new TypeReference<Map>(){});
    }

    public void sendMigrationData(String cloudId, String listenerId, Optional<String> label, byte[] payload) {
        if (!this.migrationDarkFeaturesManager.appMigrationEnabled()) {
            return;
        }
        String url = String.format("/%s", listenerId);
        if (label.isPresent()) {
            url = url + "/" + label.get();
        }
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path(url).toUriString()).put(RequestBody.create((MediaType)MediaTypes.APPLICATION_STREAM_TYPE, (byte[])payload)).build();
        this.httpService.call(request);
    }

    public Map<String, Object> getMigrationStatus(String cloudId, String appMigrationId) {
        if (!this.migrationDarkFeaturesManager.appMigrationEnabled()) {
            return Collections.emptyMap();
        }
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path("/status/" + appMigrationId).toUriString()).get().build();
        return this.httpService.callJson(request, new TypeReference<Map<String, Object>>(){});
    }

    public void addMapping(String cloudId, String migrationContextId, String namespace, Map<String, String> values) {
        if (!this.migrationDarkFeaturesManager.appMigrationEnabled()) {
            return;
        }
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path(String.format("/mapping/%s/%s", migrationContextId, namespace)).toUriString()).put(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)new Gson().toJson(values))).build();
        this.httpService.call(request);
    }

    public AppsCloudSiteResponse getAppInfoForSite(String cloudId, List<String> appKeys) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder().path("/confluence/appsinfo").toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)Jsons.valueAsString(ImmutableMap.of((Object)"appKeys", appKeys)))).build();
        return this.httpService.callJson(request, new TypeReference<AppsCloudSiteResponse>(){});
    }

    private Request.Builder getJsonBuilder(String cloudId) {
        return StargateHelper.requestBuilder(this.getContainerToken(cloudId), this.bypassStargate).addHeader("Cloud-Id", cloudId).addHeader("Accept", "application/json");
    }

    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getAppMigrationServiceBaseUrl());
    }

    private String getContainerToken(String cloudId) {
        return this.cloudSiteService.getByCloudId(cloudId).get().getContainerToken();
    }
}

