/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TaskStoreImpl
implements TaskStore {
    private static final String PARAM_PLANID = "planId";
    private static final String PARAM_STATUS = "status";
    private static final String PARAM_TYPE = "type";
    private final EntityManagerTemplate tmpl;

    @Inject
    TaskStoreImpl(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public Optional<Task> findFirstTaskWithStatusForPlan(String planId, ExecutionStatus status) {
        return this.tmpl.query(Task.class, "select task from Task task where task.plan.id=:planId and task.progress.status=:status order by task.index").param(PARAM_PLANID, (Object)planId).param(PARAM_STATUS, (Object)status).first();
    }

    @Override
    public List<Task> getTasksForPlan(String planId, Class<? extends Task> type) {
        return this.tmpl.query(Task.class, "select task from Task task where task.plan.id=:planId and TYPE(task)=:type").param(PARAM_PLANID, (Object)planId).param(PARAM_TYPE, type).list();
    }

    @Override
    public int getNumTasksForPlan(String planId, Class<? extends Task> type) {
        return this.tmpl.query(Long.class, "select count(task) from Task task where task.plan.id=:planId and TYPE(task)=:type").param(PARAM_PLANID, (Object)planId).param(PARAM_TYPE, type).first().orElse(0L).intValue();
    }

    @Override
    public int calculatePlanPercent(String planId) {
        return this.tmpl.query(Long.class, "select sum(task.progress.percent * task.weight)/sum(task.weight) from Task task where task.plan.id=:planId").param(PARAM_PLANID, (Object)planId).first().orElse(0L).intValue();
    }

    @Override
    public void update(Task task) {
        this.tmpl.merge(task);
    }

    @Override
    public void stopCreatedTasks(String planId) {
        this.tmpl.query("update Task task set task.progress.status=:newStatus where task.progress.status=:oldStatus").param("newStatus", (Object)ExecutionStatus.STOPPED).param("oldStatus", (Object)ExecutionStatus.CREATED).update();
    }

    @Override
    public boolean hasRunningTasks(String planId) {
        return this.tmpl.query(Task.class, "select task from Task task where task.plan.id=:planId and task.progress.status=:status").param(PARAM_PLANID, (Object)planId).param(PARAM_STATUS, (Object)ExecutionStatus.RUNNING).first().isPresent();
    }
}

