/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.AppAssessmentInfo;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AppAssessmentInfoStore {
    private final EntityManagerTemplate tmpl;

    @Inject
    public AppAssessmentInfoStore(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    public Optional<AppAssessmentInfo> getByAppKey(String appKey) {
        return this.tmpl.query(AppAssessmentInfo.class, "select s from AppAssessmentInfo s where s.appKey=:appKey").param("appKey", (Object)appKey).first();
    }

    public void create(AppAssessmentInfo appInfo) {
        this.tmpl.persist(appInfo);
    }

    public void updateProperty(String appKey, String propName, Object value) {
        String query = String.format("update AppAssessmentInfo info set %s = :propValue where info.appKey=:appKey", propName);
        this.tmpl.query(query).param("propValue", value).param("appKey", (Object)appKey).update();
    }

    public List<AppAssessmentInfo> getAll() {
        return this.tmpl.query(AppAssessmentInfo.class, "select info from AppAssessmentInfo info").list();
    }
}

