/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.user;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import com.atlassian.migration.agent.service.impl.UserService;
import com.atlassian.migration.agent.service.user.GroupPermission;
import com.atlassian.migration.agent.service.user.MigrationGroupDto;
import com.atlassian.migration.agent.service.user.MigrationUserDto;
import com.atlassian.migration.agent.service.user.UsersMigrationRequest;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@ParametersAreNonnullByDefault
public class UsersMigrationRequestBuilder {
    private final UserService userService;
    private final GroupManager groupManager;
    private final SpacePermissionManager spacePermissionManager;

    @Inject
    public UsersMigrationRequestBuilder(GroupManager groupManager, SpacePermissionManager spacePermissionManager, UserService userService) {
        this.groupManager = groupManager;
        this.spacePermissionManager = spacePermissionManager;
        this.userService = userService;
    }

    public UsersMigrationRequest createUsersMigrationRequest() {
        ArrayList serverGroups;
        List<MigrationUser> users = this.userService.getAllUsers();
        try {
            serverGroups = Lists.newArrayList((Iterable)this.groupManager.getGroups());
        }
        catch (EntityException e) {
            throw new RuntimeException("Couldn't retrieve groups", e);
        }
        return new UsersMigrationRequest(UsersMigrationRequestBuilder.toMigrationRequestUsers(users), this.toMigrationRequestGroups(serverGroups), this.getGroupsMembership(serverGroups, users));
    }

    private Collection<MigrationGroupDto> toMigrationRequestGroups(Collection<Group> groups) {
        return groups.stream().map(group -> {
            Collection groupPermissions = this.spacePermissionManager.getAllPermissionsForGroup(group.getName()).stream().flatMap(UsersMigrationRequestBuilder::mapSpacePermissionToGroupPermissions).collect(Collectors.toSet());
            return new MigrationGroupDto(group.getName(), groupPermissions);
        }).collect(Collectors.toList());
    }

    private Map<String, Collection<String>> getGroupsMembership(Collection<Group> groups, List<MigrationUser> users) {
        return groups.stream().collect(Collectors.toMap(Entity::getName, group -> {
            try {
                HashSet userIdsOfGroup = Sets.newHashSet((Iterable)this.groupManager.getMemberNames(group));
                return users.stream().filter(it -> userIdsOfGroup.contains(it.getUsername())).map(MigrationUser::getEmail).collect(Collectors.toList());
            }
            catch (EntityException e) {
                throw new RuntimeException(String.format("Couldn't retrieve members of group %s", group.getName()), e);
            }
        }));
    }

    private static Collection<MigrationUserDto> toMigrationRequestUsers(Collection<MigrationUser> users) {
        return users.stream().map(user -> new MigrationUserDto(user.getEmail(), user.getFullName(), user.isActive())).collect(Collectors.toList());
    }

    private static Stream<GroupPermission> mapSpacePermissionToGroupPermissions(SpacePermission spacePermission) {
        switch (spacePermission.getType()) {
            case "USECONFLUENCE": {
                return Stream.of(GroupPermission.HAS_PRODUCT_ACCESS);
            }
            case "ADMINISTRATECONFLUENCE": {
                return Stream.of(GroupPermission.PRODUCT_ADMIN);
            }
            case "SYSTEMADMINISTRATOR": {
                return Stream.of(GroupPermission.SYSTEM_ADMIN);
            }
        }
        return Stream.empty();
    }
}

