/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.attachment;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.media.MediaClientToken;
import com.atlassian.migration.agent.queue.QueueConsumer;
import com.atlassian.migration.agent.queue.QueueConsumerConfiguration;
import com.atlassian.migration.agent.service.AttachmentService;
import com.atlassian.migration.agent.service.SpaceAttachmentCount;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.UploadState;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.impl.MigrationPlatformService;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.StepSchedulerService;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrationChecker;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrator;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentsToMigrateConsumer;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentsUploadTracker;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

@Singleton
@ParametersAreNonnullByDefault
public class AttachmentMigrationExecutor
implements QueueConsumer,
JobRunner {
    private static final String STEP_ID_PARAMS_KEY = "stepId";
    private static final String SPACE_KEY_PARAMS_KEY = "spaceKey";
    private static final StepType ATTACHMENT_UPLOAD_STEP_TYPE = StepType.ATTACHMENT_UPLOAD;
    private static final Logger log = ContextLoggerFactory.getLogger(AttachmentMigrationExecutor.class);
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"migration-plugin:attachments-upload");
    private final AttachmentMigrator attachmentMigrator;
    private final AttachmentService attachmentService;
    private final CloudSiteService cloudSiteService;
    private final MigrationAgentConfiguration configuration;
    private final StatisticsService statisticsService;
    private final Supplier<ExecutorService> executorServiceSupplier;
    private final ProgressTracker progressTracker;
    private final SchedulerService schedulerService;
    private final StepSchedulerService stepSchedulerService;
    private final MigrationPlatformService migrationPlatformService;
    private final PluginTransactionTemplate ptx;
    private final StepStore stepStore;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final AttachmentMigrationChecker attachmentMigrationChecker;

    @Inject
    AttachmentMigrationExecutor(StepSchedulerService stepSchedulerService, ProgressTracker progressTracker, AttachmentService attachmentService, AttachmentMigrator attachmentMigrator, CloudSiteService cloudSiteService, MigrationAgentConfiguration migrationAgentConfiguration, SchedulerService schedulerService, StatisticsService statisticsService, MigrationPlatformService migrationPlatformService, PluginTransactionTemplate ptx, StepStore stepStore, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, AttachmentMigrationChecker attachmentMigrationChecker) {
        this(stepSchedulerService, progressTracker, attachmentService, attachmentMigrator, cloudSiteService, migrationAgentConfiguration, statisticsService, migrationPlatformService, ptx, schedulerService, Executors::newCachedThreadPool, stepStore, Instant::now, analyticsEventService, analyticsEventBuilder, attachmentMigrationChecker);
    }

    @VisibleForTesting
    AttachmentMigrationExecutor(StepSchedulerService stepSchedulerService, ProgressTracker progressTracker, AttachmentService attachmentService, AttachmentMigrator attachmentMigrator, CloudSiteService cloudSiteService, MigrationAgentConfiguration migrationAgentConfiguration, StatisticsService statisticsService, MigrationPlatformService migrationPlatformService, PluginTransactionTemplate ptx, SchedulerService schedulerService, Supplier<ExecutorService> executorServiceSupplier, StepStore stepStore, Supplier<Instant> instantSupplier, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, AttachmentMigrationChecker attachmentMigrationChecker) {
        this.stepSchedulerService = stepSchedulerService;
        this.progressTracker = progressTracker;
        this.attachmentService = attachmentService;
        this.attachmentMigrator = attachmentMigrator;
        this.cloudSiteService = cloudSiteService;
        this.configuration = migrationAgentConfiguration;
        this.statisticsService = statisticsService;
        this.migrationPlatformService = migrationPlatformService;
        this.ptx = ptx;
        this.executorServiceSupplier = executorServiceSupplier;
        this.schedulerService = schedulerService;
        this.stepStore = stepStore;
        this.instantSupplier = instantSupplier;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.attachmentMigrationChecker = attachmentMigrationChecker;
        log.info("Initialized attachment migration executor with concurrency = {} and batch size = {}.", (Object)migrationAgentConfiguration.getAttachmentUploadConcurrency(), (Object)migrationAgentConfiguration.getAttachmentUploadBatchSize());
    }

    @PostConstruct
    public void initialize() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
    }

    @Override
    public QueueConsumerConfiguration getConsumerConfiguration() {
        return QueueConsumerConfiguration.builder(ATTACHMENT_UPLOAD_STEP_TYPE.name()).withConcurrencyLevel(1).build();
    }

    @Override
    public void consume(String stepId, String jobId) {
        this.stepSchedulerService.consumeStep(stepId, ATTACHMENT_UPLOAD_STEP_TYPE, () -> {
            String stepConfig = this.ptx.read(() -> this.stepStore.getStep(stepId).getConfig());
            ImmutableMap jobParams = ImmutableMap.of((Object)SPACE_KEY_PARAMS_KEY, (Object)stepConfig, (Object)STEP_ID_PARAMS_KEY, (Object)stepId);
            this.stepSchedulerService.scheduleStepOnce(stepId, RUNNER_KEY, JobId.of((String)jobId), ATTACHMENT_UPLOAD_STEP_TYPE, (Map<String, Serializable>)jobParams);
            return Optional.empty();
        });
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        String stepId = (String)request.getJobConfig().getParameters().get(STEP_ID_PARAMS_KEY);
        String spaceKey = (String)request.getJobConfig().getParameters().get(SPACE_KEY_PARAMS_KEY);
        this.stepSchedulerService.runStep(stepId, ATTACHMENT_UPLOAD_STEP_TYPE, () -> this.doAttachmentMigration(stepId, spaceKey));
        return null;
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    StepResult doAttachmentMigration(String stepId, String spaceKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static StepResult getStepResult(UploadState uploadState) {
        if (uploadState.numOfUploadedAttachments == 0L) {
            return StepResult.succeeded("No attachments to migrate");
        }
        return StepResult.succeeded(AttachmentMigrationExecutor.getProgressMessage(uploadState));
    }

    private static String getProgressMessage(UploadState uploadState) {
        return String.format("Migrated %s of %s attachments", FileUtils.byteCountToDisplaySize((long)uploadState.uploadedBytes), FileUtils.byteCountToDisplaySize((long)uploadState.totalBytes));
    }

    private CloudSite validateAndUpdateMediaClientId(String stepId) {
        return this.ptx.write(() -> {
            CloudSite cloudSite = this.cloudSiteService.getByStepId(stepId);
            MediaClientToken mediaToken = this.migrationPlatformService.getMediaToken(cloudSite.getContainerToken());
            String currentMediaClientId = mediaToken.getClientId();
            if (currentMediaClientId.equals(cloudSite.getMediaClientId())) {
                log.info("MediaClientId is valid. Proceed with attachments migration.");
                return cloudSite;
            }
            log.info("Current mediaClientId is not valid. Going to clean attachment migration records for the Cloud Site, which means that any previously uploaded attachments will be re-uploaded.");
            int deletedCount = this.attachmentService.deleteAttachmentMigrationTrackingByCloudSite(cloudSite);
            log.info("Deleted {} attachment migration records.", (Object)deletedCount);
            return this.cloudSiteService.updateMediaClientId(cloudSite.getCloudId(), currentMediaClientId);
        });
    }

    private /* synthetic */ EventDto lambda$doAttachmentMigration$11(long startTime, String spaceKey, String planId, String taskId) {
        return this.analyticsEventBuilder.buildStepTimerEvent(this.instantSupplier.get().toEpochMilli() - startTime, "attachmentsUploaded", spaceKey, planId, taskId);
    }

    private /* synthetic */ EventDto lambda$doAttachmentMigration$10(long startTime, SpaceAttachmentCount spaceAttachmentCount, UploadState uploadState) {
        return this.analyticsEventBuilder.buildAttachmentMigrationEvent(this.instantSupplier.get().toEpochMilli() - startTime, spaceAttachmentCount, uploadState);
    }

    private static /* synthetic */ CompletableFuture[] lambda$doAttachmentMigration$9(int x$0) {
        return new CompletableFuture[x$0];
    }

    private static /* synthetic */ CompletableFuture lambda$doAttachmentMigration$8(AtomicBoolean failedToProduceOrConsumeAttachment, CompletableFuture future) {
        return future.handle((result, throwable) -> {
            if (throwable != null) {
                failedToProduceOrConsumeAttachment.set(true);
                log.error("Attachment uploader finished with exception", throwable);
            }
            return null;
        });
    }

    private static /* synthetic */ CompletableFuture lambda$doAttachmentMigration$6(ExecutorService executor, AttachmentsToMigrateConsumer consumer) {
        return CompletableFuture.runAsync(consumer, executor);
    }

    private /* synthetic */ AttachmentsToMigrateConsumer lambda$doAttachmentMigration$5(CloudSite cloudSite, BlockingQueue buffer, AttachmentsUploadTracker uploadTracker, AtomicBoolean allAttachmentsProduced, AtomicBoolean failedToProduceOrConsumeAttachment, int ignored) {
        return new AttachmentsToMigrateConsumer(cloudSite, buffer, this.attachmentMigrator, uploadTracker, allAttachmentsProduced::get, failedToProduceOrConsumeAttachment::get);
    }

    private static /* synthetic */ Object lambda$doAttachmentMigration$4(AtomicBoolean failedToProduceOrConsumeAttachment, AtomicBoolean allAttachmentsProduced, String spaceKey, Void result, Throwable throwable) {
        if (throwable != null) {
            failedToProduceOrConsumeAttachment.set(true);
            log.error("Attachments reader finished with exception", throwable);
        } else {
            allAttachmentsProduced.set(true);
            log.info("All attachments to migrate are read from {}", (Object)spaceKey);
        }
        return null;
    }

    private /* synthetic */ void lambda$doAttachmentMigration$3(String stepId, UploadState uploadState) {
        this.progressTracker.progress(stepId, uploadState.percentOfProgress, AttachmentMigrationExecutor.getProgressMessage(uploadState));
    }
}

