/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.attachment;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.SpaceAttachmentCount;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;

@Singleton
@ParametersAreNonnullByDefault
public class AttachmentMigrationChecker {
    private static final Logger log = ContextLoggerFactory.getLogger(AttachmentMigrationChecker.class);
    private final BootstrapManager bootstrapManager;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    @Inject
    public AttachmentMigrationChecker(BootstrapManager bootstrapManager, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.bootstrapManager = bootstrapManager;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    public boolean isAttachmentsDirectoryReadable() {
        String attachmentsDir = this.getAttachmentsDirectory();
        Path filePath = Paths.get(attachmentsDir, new String[0]);
        boolean isReadable = Files.isReadable(filePath);
        log.info("Attachments Directory: {} is readable: {}", (Object)attachmentsDir, (Object)isReadable);
        return isReadable;
    }

    public boolean hasMissingAttachments(SpaceAttachmentCount spaceAttachmentCount) {
        if (this.migrationDarkFeaturesManager.missingSpaceAttachmentsDisabled()) {
            log.info("Missing space attachments feature is disabled. {} attachments are missing.", (Object)spaceAttachmentCount.unRetrievableMigAttachmentCount);
            return false;
        }
        return spaceAttachmentCount.unRetrievableMigAttachmentCount > 0L;
    }

    public String getAttachmentsDirectory() {
        return this.bootstrapManager.getFilePathProperty("attachments.dir");
    }
}

