/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor;

import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.LoggingContextBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.impl.PlanConverter;
import com.atlassian.migration.agent.service.planning.StepPlanningEngine;
import com.atlassian.migration.agent.service.planning.StepPlanningEngines;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.app.DefaultRegistrar;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@Singleton
public class ProgressTracker {
    private static final Logger log = ContextLoggerFactory.getLogger(ProgressTracker.class);
    private final PluginTransactionTemplate ptx;
    private final StepPlanningEngines planningEngines;
    private final StepStore stepStore;
    private final TaskStore taskStore;
    private final PlanStore planStore;
    private final DefaultRegistrar cloudMigrationRegistrar;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final PlanConverter planConverter;

    @Inject
    ProgressTracker(PluginTransactionTemplate ptx, List<StepPlanningEngine<?>> planningEngines, StepStore stepStore, TaskStore taskStore, PlanStore planStore, DefaultRegistrar cloudMigrationRegistrar, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, PlanConverter planConverter) {
        this.ptx = ptx;
        this.planningEngines = new StepPlanningEngines(planningEngines);
        this.stepStore = stepStore;
        this.taskStore = taskStore;
        this.planStore = planStore;
        this.cloudMigrationRegistrar = cloudMigrationRegistrar;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.planConverter = planConverter;
    }

    public void started(String stepId, String message) {
        Objects.requireNonNull(stepId);
        Objects.requireNonNull(message);
        this.withStepAndWriteTx(stepId, step -> {
            log.debug("Step started, message: {}", (Object)message);
            step.setProgress(step.getProgress().copy().started(message));
            this.stepStore.update((Step)step);
            Task task = step.getTask();
            StepPlanningEngine.PercentRange percentRange = this.getStepPercentRange((Step)step);
            if (percentRange.isFirst()) {
                ExecutionStatus status = task.getProgress().getStatus();
                task.setProgress(task.getProgress().copy().started(message));
                this.saveTaskAnalyticsEvent(task, status);
            } else {
                task.setProgress(task.getProgress().copy().progress(percentRange.from, message));
            }
            this.taskStore.update(task);
        });
    }

    public void progress(String stepId, int percent, @Nullable String message) {
        Objects.requireNonNull(stepId);
        this.withStepAndWriteTx(stepId, step -> {
            StepPlanningEngine.PercentRange percentRange;
            step.setProgress(step.getProgress().copy().progress(percent, message));
            this.stepStore.update((Step)step);
            try {
                percentRange = this.getStepPercentRange((Step)step);
            }
            catch (IllegalStateException e) {
                log.error("Cannot get step range, skipping update of task", (Throwable)e);
                return;
            }
            Task task = step.getTask();
            int newPercent = percentRange.from + (percentRange.to - percentRange.from) * percent / 100;
            task.setProgress(task.getProgress().copy().progress(newPercent, message));
            this.taskStore.update(task);
        });
    }

    public void completed(String stepId, StepResult result) {
        Objects.requireNonNull(stepId);
        Objects.requireNonNull(result);
        this.withStepAndWriteTx(stepId, step -> {
            if (result.isSuccess()) {
                this.done((Step)step, result.getMessage(), result.getResult());
            } else if (result.isStopped()) {
                this.stopped((Step)step);
            } else {
                this.failed((Step)step, result.getMessage(), result.getException());
            }
        });
    }

    private StepPlanningEngine.PercentRange getStepPercentRange(Step step) {
        Task task = step.getTask();
        StepPlanningEngine<? extends Task> engine = this.planningEngines.of(task).orElseThrow(() -> new IllegalStateException("Unknown task type " + task.getClass()));
        Optional<StepPlanningEngine.PercentRange> maybeRange = engine.getStepPercentRange(step);
        return maybeRange.orElseThrow(() -> new IllegalStateException("Unknown step type " + step.getType()));
    }

    private void updatePlanWhenStepDone(Task task) {
        String planId = task.getPlan().getId();
        Plan plan = this.planStore.getPlanAndLock(planId);
        Progress planProgress = plan.getProgress();
        if (planProgress.getStatus().isCompleted()) {
            log.debug("Plan is completed, progress will not be updated further");
            return;
        }
        Progress newProgress = planProgress.copy().progress(this.taskStore.calculatePlanPercent(planId));
        plan.setProgress(newProgress);
        this.planStore.updatePlan(plan);
    }

    public void stopPlan(String planId) {
        this.ptx.write(() -> {
            Plan plan = this.planStore.getPlanAndLock(planId);
            ExecutionStatus status = plan.getProgress().getStatus();
            Progress newProgress = plan.getProgress().copy().stopped();
            plan.setProgress(newProgress);
            this.planStore.updatePlan(plan);
            this.savePlanAnalyticsEvents(plan, status);
        });
    }

    public void failPlan(String planId, String message) {
        this.ptx.write(() -> {
            Plan plan = this.planStore.getPlanAndLock(planId);
            ExecutionStatus status = plan.getProgress().getStatus();
            Progress newProgress = plan.getProgress().copy().failed(message);
            plan.setProgress(newProgress);
            this.planStore.updatePlan(plan);
            this.savePlanAnalyticsEvents(plan, status);
        });
    }

    public void succeedPlan(String planId) {
        this.ptx.write(() -> {
            Plan plan = this.planStore.getPlanAndLock(planId);
            ExecutionStatus status = plan.getProgress().getStatus();
            Progress newProgress = plan.getProgress().copy().done();
            plan.setProgress(newProgress);
            this.planStore.updatePlan(plan);
            this.cloudMigrationRegistrar.startMigration(plan.getCloudSite().getCloudId(), plan.getId());
            this.savePlanAnalyticsEvents(plan, status);
        });
    }

    private void done(Step step, @Nullable String message, @Nullable String result) {
        StepPlanningEngine.PercentRange percentRange;
        log.debug("Step done, message: {}", (Object)message);
        try {
            percentRange = this.getStepPercentRange(step);
        }
        catch (IllegalStateException e) {
            this.failed(step, "Failed to get the step percent, just try to mark it fail", e);
            return;
        }
        step.setProgress(step.getProgress().copy().done(message, result));
        this.stepStore.update(step);
        Task task = step.getTask();
        if (percentRange.isLast()) {
            ExecutionStatus status = task.getProgress().getStatus();
            task.setProgress(task.getProgress().copy().done(message, null));
            this.saveTaskAnalyticsEvent(task, status);
        } else {
            task.setProgress(task.getProgress().copy().progress(percentRange.to, message));
        }
        this.taskStore.update(task);
        this.updatePlanWhenStepDone(task);
    }

    private void stopped(Step step) {
        log.debug("Step stopped");
        step.setProgress(step.getProgress().copy().stopped());
        this.stepStore.update(step);
        Task task = step.getTask();
        ExecutionStatus status = task.getProgress().getStatus();
        task.setProgress(task.getProgress().copy().stopped());
        this.taskStore.update(task);
        this.saveTaskAnalyticsEvent(task, status);
        this.updatePlanWhenStepDone(task);
    }

    private void failed(Step step, String message, @Nullable Throwable e) {
        log.error("Step failed, message: {}", (Object)message, (Object)e);
        step.setProgress(step.getProgress().copy().failed(message));
        this.stepStore.update(step);
        Task task = step.getTask();
        ExecutionStatus status = task.getProgress().getStatus();
        task.setProgress(task.getProgress().copy().failed(message));
        this.taskStore.update(task);
        this.saveTaskAnalyticsEvent(task, status);
        this.updatePlanWhenStepDone(task);
    }

    void savePlanAnalyticsEvents(Plan plan, ExecutionStatus status) {
        PlanDto planDto = this.planConverter.entityToDto(plan, true);
        this.analyticsEventService.saveAnalyticsEvents(() -> ImmutableList.of((Object)this.analyticsEventBuilder.buildUpdatedPlanStatusAnalyticEvent(planDto, ProgressDto.convertStatus(status, null)), (Object)this.analyticsEventBuilder.buildCompletedPlanAnalyticsEvent(planDto)));
    }

    void saveTaskAnalyticsEvent(Task task, ExecutionStatus status) {
        boolean confluenceSpaceTask = task instanceof ConfluenceSpaceTask;
        this.analyticsEventService.saveAnalyticsEvent(() -> this.analyticsEventBuilder.buildUpdatedTaskStatusAnalyticEvent(task.getPlan().getId(), task.getId(), confluenceSpaceTask ? "confluence-space" : "users-and-groups", ProgressDto.convertStatus(status, null), ProgressDto.convertStatus(task.getProgress().getStatus(), null), confluenceSpaceTask ? ((ConfluenceSpaceTask)task).getSpaceKey() : null));
    }

    private void withStepAndWriteTx(String stepId, Consumer<Step> consumer) {
        this.ptx.write(() -> {
            Step step = this.stepStore.getAndLock(stepId);
            LoggingContextBuilder.logCtx().withStep(step).execute(() -> consumer.accept(step));
        });
    }
}

