/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.planning;

import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.MigrateUsersTask;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.store.TaskStore;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TaskPlanningEngine {
    private final TaskStore taskStore;

    @Inject
    public TaskPlanningEngine(TaskStore taskStore) {
        this.taskStore = taskStore;
    }

    public List<Task> getFirstTasks(String planId) {
        List<Task> migrateTask = this.taskStore.getTasksForPlan(planId, MigrateUsersTask.class);
        if (!migrateTask.isEmpty()) {
            return migrateTask;
        }
        return this.taskStore.getTasksForPlan(planId, ConfluenceSpaceTask.class);
    }

    public List<Task> getNextTasks(Task task) {
        if (task instanceof MigrateUsersTask) {
            return this.taskStore.getTasksForPlan(task.getPlan().getId(), ConfluenceSpaceTask.class);
        }
        return Collections.emptyList();
    }
}

