/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.crowd.embedded.atlassianuser.EmbeddedCrowdUser;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@ParametersAreNonnullByDefault
public class UserService {
    private final UserManager userManager;

    @Inject
    public UserService(UserManager userManager) {
        this.userManager = userManager;
    }

    public List<MigrationUser> getAllUsers() {
        try {
            return StreamSupport.stream(this.userManager.getUsers().spliterator(), false).map(UserService::userToMigrationUser).collect(Collectors.toList());
        }
        catch (EntityException e) {
            throw new RuntimeException("Couldn't retrieve users", e);
        }
    }

    private static MigrationUser userToMigrationUser(User user) {
        boolean isActive = true;
        if (user instanceof EmbeddedCrowdUser) {
            isActive = ((EmbeddedCrowdUser)user).isActive();
        }
        return new MigrationUser(user.getName(), Optional.ofNullable(user.getFullName()).orElse(""), Optional.ofNullable(user.getEmail()).orElse(""), isActive);
    }
}

