/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.cmpt.domain.Edition;
import com.atlassian.migration.agent.dto.CloudSiteDto;
import com.atlassian.migration.agent.dto.ConfluenceSpaceTaskDto;
import com.atlassian.migration.agent.dto.MigrateUsersTaskDto;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.dto.TaskDto;
import com.atlassian.migration.agent.entity.CloudEdition;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.MigrateUsersTask;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.service.EntityDtoConverter;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hibernate.Hibernate;

@Singleton
@ParametersAreNonnullByDefault
public class PlanConverter
extends EntityDtoConverter<PlanDto, Plan> {
    private final CloudSiteService cloudSiteService;

    @Inject
    PlanConverter(CloudSiteService cloudSiteService) {
        this.cloudSiteService = cloudSiteService;
    }

    @Override
    public void copyDtoToEntity(PlanDto src, Plan dest) {
        String oldCloudId;
        dest.setName(src.getName());
        dest.setLastUpdate(src.getLastUpdate());
        dest.setId(src.getId());
        List<Task> tasks = src.getTasks().stream().map(taskDto -> {
            Task task = taskDto.toInternalType();
            task.setPlan(dest);
            return task;
        }).collect(Collectors.toList());
        dest.setTasks(tasks);
        String newCloudId = src.getCloudSite() == null ? null : src.getCloudSite().getCloudId();
        String string = oldCloudId = dest.getCloudSite() == null ? null : dest.getCloudSite().getCloudId();
        if (newCloudId != null && !newCloudId.equals(oldCloudId)) {
            CloudSite cloudSite = this.cloudSiteService.getByCloudId(newCloudId).orElseThrow(() -> new IllegalArgumentException(String.format("cloudId is not known: %s", newCloudId)));
            dest.setCloudSite(cloudSite);
        }
    }

    @Override
    public PlanDto entityToDto(Plan src) {
        return this.entityToDto(src, false);
    }

    public PlanDto entityToDto(Plan src, boolean expandTasks) {
        CloudSite cloudSite = src.getCloudSite();
        Edition cloudEditionKey = Optional.ofNullable(cloudSite.getEdition()).map(CloudEdition::getKey).orElse(null);
        PlanDto.Builder builder = PlanDto.builder().id(src.getId()).name(src.getName()).lastUpdate(src.getLastUpdate()).createdTime(src.getCreatedTime()).cloudSite(new CloudSiteDto(cloudSite.getCloudUrl(), cloudSite.getCloudId(), cloudEditionKey)).progress(ProgressDto.fromPlanEntity(src.getProgress()));
        if (expandTasks) {
            List<TaskDto> taskDtos = src.getTasks().stream().map(task -> PlanConverter.taskEntityToDto(task, src)).collect(Collectors.toList());
            builder.tasks(taskDtos);
        }
        return builder.build();
    }

    private static TaskDto taskEntityToDto(Task src, Plan plan) {
        ProgressDto progressDto = ProgressDto.fromTaskEntity(src.getProgress(), plan.getProgress().getStatus());
        Object unproxiedObject = Hibernate.unproxy((Object)src);
        if (unproxiedObject instanceof ConfluenceSpaceTask) {
            ConfluenceSpaceTask confluenceSpaceTask = (ConfluenceSpaceTask)unproxiedObject;
            return new ConfluenceSpaceTaskDto(confluenceSpaceTask.getId(), confluenceSpaceTask.getName(), confluenceSpaceTask.getSpaceKey(), progressDto);
        }
        if (unproxiedObject instanceof MigrateUsersTask) {
            MigrateUsersTask migrateUsersTask = (MigrateUsersTask)unproxiedObject;
            return new MigrateUsersTaskDto(migrateUsersTask.getId(), migrateUsersTask.getName(), progressDto);
        }
        throw new IllegalArgumentException(String.format("Task of type %s is not supported yet", unproxiedObject.getClass().getSimpleName()));
    }
}

