/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.memory.MemoryCacheManager;
import com.atlassian.fugue.Pair;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.HttpServiceException;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.service.MigrationAppAggregatorResponse;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

@Singleton
@ParametersAreNonnullByDefault
public class MigrationAppAggregatorService {
    private static final String MAA_CACHE_NAME = "migrationMarketplaceAppsCache";
    private static final String BLACKLIST_CACHE_NAME = "appAssessmentBlacklistCache";
    private static final String APP_ASSESSMENT_BLACKLIST_KEY = "appAssessmentBlacklistKey";
    private final HttpService httpService;
    private final MigrationAgentConfiguration configuration;
    private final RetryPolicy retryPolicy;
    private final Cache<Pair<Hosting, String>, MigrationAppAggregatorResponse> maaCache;
    private final Cache<String, Set<String>> appAssessmentBlacklistCache;
    private static final Logger LOG = LoggerFactory.getLogger(MigrationAppAggregatorService.class);

    @Inject
    public MigrationAppAggregatorService(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor, CacheManager cacheManager) {
        this(new HttpService(() -> MigrationAppAggregatorService.buildHttpClient(userAgentInterceptor)), configuration, cacheManager, RetryPolicyBuilder.defaultPolicy().build());
    }

    @VisibleForTesting
    MigrationAppAggregatorService(HttpService httpService, MigrationAgentConfiguration configuration, CacheManager cacheManager, RetryPolicy retryPolicy) {
        this.maaCache = cacheManager.getCache(MAA_CACHE_NAME, this::getAggregatedAppData, new CacheSettingsBuilder().expireAfterWrite(55L, TimeUnit.MINUTES).build());
        this.appAssessmentBlacklistCache = cacheManager.getCache(BLACKLIST_CACHE_NAME, (CacheLoader)new BlacklistCacheLoader(), new CacheSettingsBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build());
        this.httpService = httpService;
        this.configuration = configuration;
        this.retryPolicy = retryPolicy;
        this.maaCache.removeAll();
        this.appAssessmentBlacklistCache.removeAll();
    }

    @VisibleForTesting
    public MigrationAppAggregatorService(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor, MemoryCacheManager cacheManager, RetryPolicy retryPolicy) {
        this(new HttpService(() -> MigrationAppAggregatorService.buildHttpClient(userAgentInterceptor)), configuration, (CacheManager)cacheManager, retryPolicy);
    }

    public MigrationAppAggregatorResponse getCachedServerAppData(String pluginKey) {
        return this.getCachedOrEmpty((Pair<Hosting, String>)Pair.pair((Object)((Object)Hosting.server), (Object)pluginKey));
    }

    public MigrationAppAggregatorResponse getCachedCloudAppData(String pluginKey) {
        return this.getCachedOrEmpty((Pair<Hosting, String>)Pair.pair((Object)((Object)Hosting.cloud), (Object)pluginKey));
    }

    public void validateAndReloadBlacklist() {
        Set blacklist = (Set)this.appAssessmentBlacklistCache.get((Object)APP_ASSESSMENT_BLACKLIST_KEY);
        if (blacklist.isEmpty()) {
            this.appAssessmentBlacklistCache.put((Object)APP_ASSESSMENT_BLACKLIST_KEY, this.getAppAssessmentBlacklistFromAggregator());
        }
    }

    public boolean isBlacklisted(String pluginKey) {
        return ((Set)this.appAssessmentBlacklistCache.get((Object)APP_ASSESSMENT_BLACKLIST_KEY)).contains(pluginKey);
    }

    private MigrationAppAggregatorResponse getCachedOrEmpty(Pair<Hosting, String> cacheKey) {
        MigrationAppAggregatorResponse cached = (MigrationAppAggregatorResponse)this.maaCache.get(cacheKey);
        if (this.isFailedResponse(cached)) {
            this.maaCache.remove(cacheKey);
        }
        return cached;
    }

    private boolean isFailedResponse(MigrationAppAggregatorResponse cached) {
        return cached.getAggregatorHttpErrorCode() != null && cached.getAggregatorHttpErrorCode() >= 500;
    }

    @Nonnull
    private MigrationAppAggregatorResponse getAggregatedAppData(Pair<Hosting, String> pluginKey) {
        try {
            Request request = new Request.Builder().addHeader("Accept", "application/json").url(this.getUriBuilder().path("/" + (String)pluginKey.right()).query("application=confluence").query("hosting=" + pluginKey.left()).toUriString()).get().build();
            return this.callJsonWithRetries(request, new TypeReference<MigrationAppAggregatorResponse>(){});
        }
        catch (HttpServiceException e) {
            LOG.warn("Failed to talk to app-aggregator. Returning default values. Error code: {}", (Object)e.getStatusCode());
            return MigrationAppAggregatorResponse.empty(e.getStatusCode());
        }
    }

    private Set<String> getAppAssessmentBlacklistFromAggregator() {
        try {
            Request request = new Request.Builder().addHeader("Accept", "application/json").url(this.getUriBuilder().path("/resources/blacklist").toUriString()).get().build();
            return this.callJsonWithRetries(request, new TypeReference<HashSet<String>>(){});
        }
        catch (HttpServiceException e) {
            LOG.warn("Failed to get app assessment blacklist from app-aggregator. Returning empty blacklist. Error code: {}", (Object)e.getStatusCode());
            return new HashSet<String>();
        }
    }

    private <T> T callJsonWithRetries(Request request, TypeReference<T> bodyType) {
        return (T)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.httpService.callJson(request, bodyType));
    }

    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getMigrationAppAggregatorUrl());
    }

    private static OkHttpClient buildHttpClient(UserAgentInterceptor userAgentInterceptor) {
        return new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).build();
    }

    private class BlacklistCacheLoader
    implements CacheLoader<String, Set<String>> {
        private BlacklistCacheLoader() {
        }

        @Nonnull
        public Set<String> load(@Nonnull String key) {
            if (!key.equals(MigrationAppAggregatorService.APP_ASSESSMENT_BLACKLIST_KEY)) {
                throw new IllegalArgumentException("Invalid key used with blacklist cache : " + key);
            }
            return MigrationAppAggregatorService.this.getAppAssessmentBlacklistFromAggregator();
        }
    }

    static enum Hosting {
        server,
        cloud;

    }
}

