/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.PlanService;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.AppAssessmentAnalyticsEventService;
import com.atlassian.migration.agent.service.check.CheckResultsService;
import com.atlassian.migration.agent.service.impl.PlanConverter;
import com.atlassian.migration.agent.service.planning.StepCoordinator;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.NoResultException;
import org.slf4j.Logger;

@Singleton
@ParametersAreNonnullByDefault
public class DefaultPlanService
implements PlanService {
    private static final Logger log = ContextLoggerFactory.getLogger(DefaultPlanService.class);
    private final PluginTransactionTemplate ptx;
    private final StepCoordinator stepCoordinator;
    private final PlanStore planStore;
    private final TaskStore taskStore;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final PlanConverter planConverter;
    private final CheckResultsService checkResultsService;
    private final AppAssessmentAnalyticsEventService appAssessmentAnalyticsEventService;

    @Inject
    DefaultPlanService(PluginTransactionTemplate ptx, StepCoordinator stepCoordinator, PlanStore planStore, TaskStore taskStore, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, PlanConverter planConverter, CheckResultsService checkResultsService, AppAssessmentAnalyticsEventService appAssessmentAnalyticsEventService) {
        this.ptx = ptx;
        this.stepCoordinator = stepCoordinator;
        this.planStore = planStore;
        this.taskStore = taskStore;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.planConverter = planConverter;
        this.checkResultsService = checkResultsService;
        this.appAssessmentAnalyticsEventService = appAssessmentAnalyticsEventService;
    }

    @Override
    @Nonnull
    public List<PlanDto> getAllPlans() {
        return this.ptx.read(() -> this.planStore.getAllPlans().stream().map(plan -> this.planConverter.entityToDto((Plan)plan, false)).collect(Collectors.toList()));
    }

    @Override
    public PlanDto getPlan(String planId) {
        return this.ptx.read(() -> this.planConverter.entityToDto(this.getPlanById(planId), true));
    }

    @Override
    public boolean planNameExists(String planName) {
        return this.ptx.read(() -> this.planStore.planNameExists(planName));
    }

    @Override
    public ProgressDto getPlanProgress(String planId) {
        return this.ptx.read(() -> ProgressDto.fromPlanEntity(this.getPlanById(planId).getProgress()));
    }

    @Override
    @Nonnull
    public PlanDto createPlan(PlanDto planDto) {
        return this.ptx.write(() -> {
            Plan plan = (Plan)this.planConverter.dtoToEntity(planDto);
            PlanDto persistedPlan = this.planConverter.entityToDto(this.planStore.createPlan(plan), true);
            this.checkResultsService.bindCheckIdToPlanId(planDto.getCheckExecutionId(), persistedPlan.getId());
            return persistedPlan;
        });
    }

    @Override
    public PlanDto updatePlan(PlanDto plan) {
        Objects.requireNonNull(plan);
        return this.ptx.write(() -> {
            Plan entity;
            String planId = plan.getId();
            try {
                entity = this.planStore.getPlanAndLock(planId);
            }
            catch (NoResultException e) {
                throw new IllegalArgumentException("Failed to update, no plan with ID " + planId, e);
            }
            if (entity.getProgress().getStatus() != ExecutionStatus.CREATED) {
                throw new IllegalStateException("Plan only can be updated when in CREATED state");
            }
            this.planStore.removeTasks(entity);
            this.planConverter.copyDtoToEntity(plan, entity);
            this.planStore.updatePlan(entity);
            return this.planConverter.entityToDto(entity, true);
        });
    }

    @Override
    public boolean stop(String planId) {
        return this.ptx.write(() -> {
            Plan plan = this.planStore.getPlanAndLock(planId);
            ExecutionStatus status = plan.getProgress().getStatus();
            if (!status.canGo(ExecutionStatus.STOPPING)) {
                return false;
            }
            plan.setProgress(plan.getProgress().copy().stopping());
            this.planStore.updatePlan(plan);
            this.stepCoordinator.cancelAndStopReadySteps(planId);
            this.taskStore.stopCreatedTasks(planId);
            if (!this.taskStore.hasRunningTasks(planId)) {
                plan.setProgress(plan.getProgress().copy().stopped());
                this.planStore.updatePlan(plan);
            }
            PlanDto planDto = this.planConverter.entityToDto(plan, true);
            this.analyticsEventService.saveAnalyticsEvent(() -> this.analyticsEventBuilder.buildUpdatedPlanStatusAnalyticEvent(planDto, ProgressDto.convertStatus(status, null)));
            return true;
        });
    }

    @Override
    public boolean hasPlans(ExecutionStatus ... statuses) {
        return this.ptx.read(() -> this.planStore.hasPlans(statuses));
    }

    private Plan getPlanById(String planId) {
        try {
            return this.planStore.getPlan(planId);
        }
        catch (NoResultException e) {
            throw new IllegalArgumentException(String.format("Plan with ID %s could not be found", planId), e);
        }
    }

    @Override
    public PlanDto verifyPlan(String planId) {
        return this.ptx.write(() -> {
            Plan plan = this.planStore.getPlanAndLock(planId);
            ExecutionStatus status = plan.getProgress().getStatus();
            if (!status.canGo(ExecutionStatus.VALIDATING)) {
                throw new IllegalArgumentException("Failed to change status to VALIDATING with plan ID " + planId);
            }
            plan.setProgress(plan.getProgress().copy().validating());
            this.planStore.updatePlan(plan);
            return this.planConverter.entityToDto(plan, true);
        });
    }

    @Override
    public void setCreatedStatus(String planId) {
        this.ptx.write(() -> {
            Plan plan = this.planStore.getPlanAndLock(planId);
            ExecutionStatus status = plan.getProgress().getStatus();
            if (!status.canGo(ExecutionStatus.CREATED)) {
                log.error("Failed to change status to CREATED with plan ID {}", (Object)planId);
                return;
            }
            plan.setProgress(Progress.created());
            this.planStore.updatePlan(plan);
        });
    }

    @Override
    public void startPlan(String planId) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        this.ptx.write(() -> {
            Plan plan = this.planStore.getPlanAndLock(planId);
            ExecutionStatus status = plan.getProgress().getStatus();
            if (!status.canGo(ExecutionStatus.RUNNING)) {
                log.error("Failed to change status to RUNNING with plan ID {}", (Object)planId);
                return;
            }
            plan.setProgress(plan.getProgress().copy().started());
            this.planStore.updatePlan(plan);
            this.stepCoordinator.schedulePlan(planId);
            PlanDto planDto = this.planConverter.entityToDto(plan, true);
            this.analyticsEventService.saveAnalyticsEvent(() -> this.analyticsEventBuilder.buildStartPlanAnalyticsEvent(planDto));
            this.appAssessmentAnalyticsEventService.saveStartPlanEvent(confluenceUser);
        });
    }
}

