/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import com.atlassian.cmpt.check.base.CheckExecutor;
import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.check.CheckResultsService;
import com.atlassian.migration.agent.service.check.CheckTransformerService;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.app.DefaultRegistrar;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

@Singleton
public class PreflightService {
    private static final Logger log = ContextLoggerFactory.getLogger(PreflightService.class);
    private final CheckExecutor checkExecutor;
    private final CheckTransformerService checkTransformerService;
    private final CheckResultsService checkResultService;
    private final DefaultRegistrar appMigrationRegistrar;

    @Inject
    PreflightService(CheckExecutor checkExecutor, CheckTransformerService checkTransformerService, CheckResultsService checkResultService, DefaultRegistrar appMigrationRegistrar) {
        this.checkExecutor = checkExecutor;
        this.checkTransformerService = checkTransformerService;
        this.checkResultService = checkResultService;
        this.appMigrationRegistrar = appMigrationRegistrar;
    }

    public List<CheckResultDto> getCheckExecutionStatus(String executionId) {
        ArrayList<CheckResultDto> results = new ArrayList<CheckResultDto>();
        Optional maybeStatus = this.checkExecutor.getStatus(executionId);
        maybeStatus.ifPresent(checkExecutionStatus -> results.addAll(this.checkTransformerService.toCheckResultDtos(checkExecutionStatus.statuses)));
        results.addAll(this.checkTransformerService.toCheckResultDtos(this.appMigrationRegistrar.getPreflightResults(executionId)));
        return results;
    }

    public void executeChecks(String executionId, PlanDto planDto, Set<CheckType> types) {
        this.appMigrationRegistrar.runPreflightChecks(executionId);
        List<CheckRequest> checkRequests = this.checkTransformerService.getCheckRequests(planDto, types);
        if (CollectionUtils.isEmpty(types)) {
            this.checkResultService.deleteCheckResultsByExecutionId(executionId);
        }
        this.checkExecutor.executeChecks(executionId, checkRequests);
        log.info("Scheduled checks: {}", (Object)checkRequests.stream().map(ch -> ch.checkType).collect(Collectors.joining(", ")));
    }
}

