/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.MediaTypes;
import com.atlassian.migration.agent.okhttp.ServiceErrorCodeHandler;
import com.atlassian.migration.agent.service.analytics.ExternalAnalyticsEventDto;
import com.atlassian.migration.agent.service.impl.StargateHelper;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.web.util.UriComponentsBuilder;

@Singleton
@ParametersAreNonnullByDefault
class AnalyticsSenderService {
    private static final String EVENT_PATH = "/confluenceMigration/event";
    private final HttpService httpService;
    private final MigrationAgentConfiguration configuration;

    @Inject
    AnalyticsSenderService(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor) {
        this(new HttpService(() -> AnalyticsSenderService.buildHttpClient(userAgentInterceptor), new ServiceErrorCodeHandler()), configuration);
    }

    @VisibleForTesting
    AnalyticsSenderService(HttpService httpService, MigrationAgentConfiguration configuration) {
        this.httpService = httpService;
        this.configuration = configuration;
    }

    boolean sendAnalyticsEventBatch(String containerToken, Collection<ExternalAnalyticsEventDto> events) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).addHeader("Accept", "application/json").url(this.getUriBuilderForMigrationAnalytics().path(EVENT_PATH).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)Jsons.valueAsString(events))).build();
        return this.httpService.callJson(request, new TypeReference<Boolean>(){});
    }

    private UriComponentsBuilder getUriBuilderForMigrationAnalytics() {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getMigrationAnalyticsServiceBaseUrl());
    }

    private static OkHttpClient buildHttpClient(UserAgentInterceptor userAgentInterceptor) {
        return new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).build();
    }
}

