/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.EventType;
import com.atlassian.migration.agent.entity.AnalyticsEvent;
import com.atlassian.migration.agent.entity.AnalyticsEventType;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.LoggingContextAwareExecutorService;
import com.atlassian.migration.agent.store.impl.AnalyticsEventStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AnalyticsEventService {
    private final PluginTransactionTemplate ptx;
    private final AnalyticsEventStore analyticsEventStore;
    private final ExecutorService executorService;

    @Inject
    public AnalyticsEventService(PluginTransactionTemplate ptx, AnalyticsEventStore analyticsEventStore) {
        this(ptx, analyticsEventStore, new LoggingContextAwareExecutorService(Executors.newCachedThreadPool()));
    }

    @VisibleForTesting
    AnalyticsEventService(PluginTransactionTemplate ptx, AnalyticsEventStore analyticsEventStore, ExecutorService executorService) {
        this.ptx = ptx;
        this.analyticsEventStore = analyticsEventStore;
        this.executorService = executorService;
    }

    @PreDestroy
    public void cleanup() {
        this.executorService.shutdownNow();
    }

    public void saveAnalyticsEvent(Supplier<EventDto> eventSupplier) {
        this.saveAnalyticsEvents(() -> Collections.singletonList(eventSupplier.get()));
    }

    public void saveAnalyticsEvents(Supplier<Collection<? extends EventDto>> eventSupplier) {
        this.executorService.execute(() -> {
            Collection analyticsEvents = (Collection)eventSupplier.get();
            analyticsEvents.forEach(this::storeAnalyticsEvent);
        });
    }

    private void storeAnalyticsEvent(EventDto analyticsEvent) {
        this.ptx.write(() -> this.analyticsEventStore.createAnalyticsEvent(this.convertToEntity(analyticsEvent)));
    }

    private AnalyticsEvent convertToEntity(EventDto event) {
        AnalyticsEvent analyticsEvent = new AnalyticsEvent();
        analyticsEvent.setTimestamp(event.timestamp);
        analyticsEvent.setEventType(AnalyticsEventService.toInternalEventType(event.eventType));
        analyticsEvent.setEvent(Jsons.valueAsString(event));
        return analyticsEvent;
    }

    private static AnalyticsEventType toInternalEventType(EventType eventType) {
        switch (eventType) {
            case UI: {
                return AnalyticsEventType.UI;
            }
            case TRACK: {
                return AnalyticsEventType.TRACK;
            }
            case SCREEN: {
                return AnalyticsEventType.SCREEN;
            }
            case OPERATIONAL: {
                return AnalyticsEventType.OPERATIONAL;
            }
        }
        throw new IllegalArgumentException(String.format("EventType %s is not supported", eventType));
    }
}

