/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.model.stats;

import com.atlassian.migration.agent.model.stats.AttachmentStats;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@ParametersAreNonnullByDefault
public class ContentSummary {
    public static final ContentSummary ZERO = ContentSummary.builder().build();
    @JsonProperty
    private final long numberOfPages;
    @JsonProperty
    private final long numberOfBlogs;
    @JsonProperty
    private final long numberOfDrafts;
    @JsonProperty
    private final long numberOfAttachments;
    @JsonProperty
    private final AttachmentStats attachments;

    @JsonCreator
    private ContentSummary(@JsonProperty(value="attachments") AttachmentStats attachments, @JsonProperty(value="numberOfPages") long numberOfPages, @JsonProperty(value="numberOfBlogs") long numberOfBlogs, @JsonProperty(value="numberOfDrafts") long numberOfDrafts, @JsonProperty(value="numberOfAttachments") long numberOfAttachments) {
        this.numberOfPages = numberOfPages;
        this.numberOfBlogs = numberOfBlogs;
        this.numberOfDrafts = numberOfDrafts;
        this.numberOfAttachments = numberOfAttachments;
        this.attachments = attachments;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getNumberOfPages() {
        return this.numberOfPages;
    }

    public long getNumberOfBlogs() {
        return this.numberOfBlogs;
    }

    public long getNumberOfDrafts() {
        return this.numberOfDrafts;
    }

    public long getNumberOfAttachments() {
        return this.numberOfAttachments;
    }

    public AttachmentStats getAttachments() {
        return this.attachments;
    }

    public static final class Builder {
        private long numberOfPages;
        private long numberOfBlogs;
        private long numberOfDrafts;
        private long numberOfAttachments;
        private AttachmentStats attachments = AttachmentStats.ZERO;

        private Builder() {
        }

        @Nonnull
        public Builder numberOfPages(long numberOfPages) {
            this.numberOfPages = numberOfPages;
            return this;
        }

        @Nonnull
        public Builder numberOfBlogs(long numberOfBlogs) {
            this.numberOfBlogs = numberOfBlogs;
            return this;
        }

        @Nonnull
        public Builder numberOfDrafts(long numberOfDrafts) {
            this.numberOfDrafts = numberOfDrafts;
            return this;
        }

        @Nonnull
        public Builder numberOfAttachments(long numberOfAttachments) {
            this.numberOfAttachments = numberOfAttachments;
            return this;
        }

        @Nonnull
        public Builder attachments(AttachmentStats attachments) {
            this.attachments = attachments;
            return this;
        }

        public ContentSummary build() {
            return new ContentSummary(this.attachments, this.numberOfPages, this.numberOfBlogs, this.numberOfDrafts, this.numberOfAttachments);
        }
    }
}

